/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(66u, 72u, 87u, 75u) - 0u) => uvec4(66u, 72u, 87u, 75u)
 * (uvec4(66u, 72u, 87u, 75u) - 6u) => uvec4(60u, 66u, 81u, 69u)
 * (uvec4(66u, 72u, 87u, 75u) - 12u) => uvec4(54u, 60u, 75u, 63u)
 * (uvec4(66u, 72u, 87u, 75u) - 32u) => uvec4(34u, 40u, 55u, 43u)
 * (uvec4(66u, 72u, 87u, 75u) - 74u) => uvec4(4294967288u, 4294967294u, 13u, 1u)
 * (uvec4(24u, 40u, 23u, 74u) - 0u) => uvec4(24u, 40u, 23u, 74u)
 * (uvec4(24u, 40u, 23u, 74u) - 6u) => uvec4(18u, 34u, 17u, 68u)
 * (uvec4(24u, 40u, 23u, 74u) - 12u) => uvec4(12u, 28u, 11u, 62u)
 * (uvec4(24u, 40u, 23u, 74u) - 32u) => uvec4(4294967288u, 8u, 4294967287u, 42u)
 * (uvec4(24u, 40u, 23u, 74u) - 74u) => uvec4(4294967246u, 4294967262u, 4294967245u, 0u)
 */
#version 130

void main()
{
  float[all(equal((uvec4(66u, 72u, 87u, 75u) - 0u), uvec4(66u, 72u, 87u, 75u))) ? 1 : -1] array0;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) - 6u), uvec4(60u, 66u, 81u, 69u))) ? 1 : -1] array1;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) - 12u), uvec4(54u, 60u, 75u, 63u))) ? 1 : -1] array2;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) - 32u), uvec4(34u, 40u, 55u, 43u))) ? 1 : -1] array3;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) - 74u), uvec4(4294967288u, 4294967294u, 13u, 1u))) ? 1 : -1] array4;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) - 0u), uvec4(24u, 40u, 23u, 74u))) ? 1 : -1] array5;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) - 6u), uvec4(18u, 34u, 17u, 68u))) ? 1 : -1] array6;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) - 12u), uvec4(12u, 28u, 11u, 62u))) ? 1 : -1] array7;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) - 32u), uvec4(4294967288u, 8u, 4294967287u, 42u))) ? 1 : -1] array8;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) - 74u), uvec4(4294967246u, 4294967262u, 4294967245u, 0u))) ? 1 : -1] array9;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
