/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(38, 35) % ivec2(38, 35)) => ivec2(0, 0)
 * (ivec2(38, 35) % ivec2(64, 9)) => ivec2(38, 8)
 * (ivec2(64, 9) % ivec2(38, 35)) => ivec2(26, 9)
 * (ivec2(64, 9) % ivec2(64, 9)) => ivec2(0, 0)
 */
#version 130

void main()
{
  float[all(equal((ivec2(38, 35) % ivec2(38, 35)), ivec2(0, 0))) ? 1 : -1] array0;
  float[all(equal((ivec2(38, 35) % ivec2(64, 9)), ivec2(38, 8))) ? 1 : -1] array1;
  float[all(equal((ivec2(64, 9) % ivec2(38, 35)), ivec2(26, 9))) ? 1 : -1] array2;
  float[all(equal((ivec2(64, 9) % ivec2(64, 9)), ivec2(0, 0))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
