/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 ^ abs(- ivec4(-64, 72, 88, -76))) => ivec4(76, 68, 84, 64)
 * (12 ^ abs(- ivec4(64, 72, 88, 76))) => ivec4(76, 68, 84, 64)
 * (12 ^ abs(- ivec4(-24, 40, -23, 64))) => ivec4(20, 36, 27, 76)
 * (12 ^ abs(- ivec4(24, 40, 23, 64))) => ivec4(20, 36, 27, 76)
 * (-6 ^ abs(- ivec4(-64, 72, 88, -76))) => ivec4(-70, -78, -94, -74)
 * (-6 ^ abs(- ivec4(64, 72, 88, 76))) => ivec4(-70, -78, -94, -74)
 * (-6 ^ abs(- ivec4(-24, 40, -23, 64))) => ivec4(-30, -46, -19, -70)
 * (-6 ^ abs(- ivec4(24, 40, 23, 64))) => ivec4(-30, -46, -19, -70)
 * (76 ^ abs(- ivec4(-64, 72, 88, -76))) => ivec4(12, 4, 20, 0)
 * (76 ^ abs(- ivec4(64, 72, 88, 76))) => ivec4(12, 4, 20, 0)
 * (76 ^ abs(- ivec4(-24, 40, -23, 64))) => ivec4(84, 100, 91, 12)
 * (76 ^ abs(- ivec4(24, 40, 23, 64))) => ivec4(84, 100, 91, 12)
 * (-32 ^ abs(- ivec4(-64, 72, 88, -76))) => ivec4(-96, -88, -72, -84)
 * (-32 ^ abs(- ivec4(64, 72, 88, 76))) => ivec4(-96, -88, -72, -84)
 * (-32 ^ abs(- ivec4(-24, 40, -23, 64))) => ivec4(-8, -56, -9, -96)
 * (-32 ^ abs(- ivec4(24, 40, 23, 64))) => ivec4(-8, -56, -9, -96)
 * (0 ^ abs(- ivec4(-64, 72, 88, -76))) => ivec4(64, 72, 88, 76)
 * (0 ^ abs(- ivec4(64, 72, 88, 76))) => ivec4(64, 72, 88, 76)
 * (0 ^ abs(- ivec4(-24, 40, -23, 64))) => ivec4(24, 40, 23, 64)
 * (0 ^ abs(- ivec4(24, 40, 23, 64))) => ivec4(24, 40, 23, 64)
 */
#version 130

void main()
{
  float[all(equal((12 ^ abs(- ivec4(-64, 72, 88, -76))), ivec4(76, 68, 84, 64))) ? 1 : -1] array0;
  float[all(equal((12 ^ abs(- ivec4(64, 72, 88, 76))), ivec4(76, 68, 84, 64))) ? 1 : -1] array1;
  float[all(equal((12 ^ abs(- ivec4(-24, 40, -23, 64))), ivec4(20, 36, 27, 76))) ? 1 : -1] array2;
  float[all(equal((12 ^ abs(- ivec4(24, 40, 23, 64))), ivec4(20, 36, 27, 76))) ? 1 : -1] array3;
  float[all(equal((-6 ^ abs(- ivec4(-64, 72, 88, -76))), ivec4(-70, -78, -94, -74))) ? 1 : -1] array4;
  float[all(equal((-6 ^ abs(- ivec4(64, 72, 88, 76))), ivec4(-70, -78, -94, -74))) ? 1 : -1] array5;
  float[all(equal((-6 ^ abs(- ivec4(-24, 40, -23, 64))), ivec4(-30, -46, -19, -70))) ? 1 : -1] array6;
  float[all(equal((-6 ^ abs(- ivec4(24, 40, 23, 64))), ivec4(-30, -46, -19, -70))) ? 1 : -1] array7;
  float[all(equal((76 ^ abs(- ivec4(-64, 72, 88, -76))), ivec4(12, 4, 20, 0))) ? 1 : -1] array8;
  float[all(equal((76 ^ abs(- ivec4(64, 72, 88, 76))), ivec4(12, 4, 20, 0))) ? 1 : -1] array9;
  float[all(equal((76 ^ abs(- ivec4(-24, 40, -23, 64))), ivec4(84, 100, 91, 12))) ? 1 : -1] array10;
  float[all(equal((76 ^ abs(- ivec4(24, 40, 23, 64))), ivec4(84, 100, 91, 12))) ? 1 : -1] array11;
  float[all(equal((-32 ^ abs(- ivec4(-64, 72, 88, -76))), ivec4(-96, -88, -72, -84))) ? 1 : -1] array12;
  float[all(equal((-32 ^ abs(- ivec4(64, 72, 88, 76))), ivec4(-96, -88, -72, -84))) ? 1 : -1] array13;
  float[all(equal((-32 ^ abs(- ivec4(-24, 40, -23, 64))), ivec4(-8, -56, -9, -96))) ? 1 : -1] array14;
  float[all(equal((-32 ^ abs(- ivec4(24, 40, 23, 64))), ivec4(-8, -56, -9, -96))) ? 1 : -1] array15;
  float[all(equal((0 ^ abs(- ivec4(-64, 72, 88, -76))), ivec4(64, 72, 88, 76))) ? 1 : -1] array16;
  float[all(equal((0 ^ abs(- ivec4(64, 72, 88, 76))), ivec4(64, 72, 88, 76))) ? 1 : -1] array17;
  float[all(equal((0 ^ abs(- ivec4(-24, 40, -23, 64))), ivec4(24, 40, 23, 64))) ? 1 : -1] array18;
  float[all(equal((0 ^ abs(- ivec4(24, 40, 23, 64))), ivec4(24, 40, 23, 64))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
