/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * step(vec3(-2.0, -2.0, -2.0), vec3(-2.0, -0.6666667, 0.6666667)) => vec3(1.0, 1.0, 1.0)
 * step(vec3(-2.0, -0.6666667, -0.6666667), vec3(2.0, -2.0, -0.6666667)) => vec3(1.0, 0.0, 1.0)
 * step(vec3(-0.6666667, -0.6666667, 0.6666667), vec3(0.6666667, 2.0, -2.0)) => vec3(1.0, 1.0, 0.0)
 * step(vec3(0.6666667, 0.6666667, 0.6666667), vec3(-0.6666667, 0.6666667, 2.0)) => vec3(0.0, 1.0, 1.0)
 * step(vec3(2.0, 2.0, 2.0), vec3(-2.0, -0.6666667, 0.6666667)) => vec3(0.0, 0.0, 0.0)
 * step(vec3(2.0, -2.0, -2.0), vec3(2.0, -2.0, -0.6666667)) => vec3(1.0, 1.0, 1.0)
 */
#version 120

void main()
{
  float[distance(step(vec3(-2.0, -2.0, -2.0), vec3(-2.0, -0.6666667, 0.6666667)), vec3(1.0, 1.0, 1.0)) <= 1.7320508e-05 ? 1 : -1] array0;
  float[distance(step(vec3(-2.0, -0.6666667, -0.6666667), vec3(2.0, -2.0, -0.6666667)), vec3(1.0, 0.0, 1.0)) <= 1.4142135e-05 ? 1 : -1] array1;
  float[distance(step(vec3(-0.6666667, -0.6666667, 0.6666667), vec3(0.6666667, 2.0, -2.0)), vec3(1.0, 1.0, 0.0)) <= 1.4142135e-05 ? 1 : -1] array2;
  float[distance(step(vec3(0.6666667, 0.6666667, 0.6666667), vec3(-0.6666667, 0.6666667, 2.0)), vec3(0.0, 1.0, 1.0)) <= 1.4142135e-05 ? 1 : -1] array3;
  float[distance(step(vec3(2.0, 2.0, 2.0), vec3(-2.0, -0.6666667, 0.6666667)), vec3(0.0, 0.0, 0.0)) <= 0.0 ? 1 : -1] array4;
  float[distance(step(vec3(2.0, -2.0, -2.0), vec3(2.0, -2.0, -0.6666667)), vec3(1.0, 1.0, 1.0)) <= 1.7320508e-05 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
