/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * pow(vec2(0.0, 0.0), vec2(0.6666667, 2.0)) => vec2(0.0, 0.0)
 * pow(vec2(0.6666667, 0.6666667), vec2(-2.0, -0.6666667)) => vec2(2.2499998, 1.3103707)
 * pow(vec2(0.6666667, 0.6666667), vec2(0.6666667, 2.0)) => vec2(0.7631428, 0.44444448)
 * pow(vec2(1.3333334, 1.3333334), vec2(-2.0, -0.6666667)) => vec2(0.56249994, 0.8254818)
 * pow(vec2(1.3333334, 1.3333334), vec2(0.6666667, 2.0)) => vec2(1.2114137, 1.7777779)
 * pow(vec2(2.0, 2.0), vec2(-2.0, -0.6666667)) => vec2(0.25, 0.62996054)
 * pow(vec2(2.0, 2.0), vec2(0.6666667, 2.0)) => vec2(1.587401, 4.0)
 */
#version 120

void main()
{
  float[distance(pow(vec2(0.0, 0.0), vec2(0.6666667, 2.0)), vec2(0.0, 0.0)) <= 0.0 ? 1 : -1] array0;
  float[distance(pow(vec2(0.6666667, 0.6666667), vec2(-2.0, -0.6666667)), vec2(2.2499998, 1.3103707)) <= 2.603761e-05 ? 1 : -1] array1;
  float[distance(pow(vec2(0.6666667, 0.6666667), vec2(0.6666667, 2.0)), vec2(0.7631428, 0.44444448)) <= 8.831295e-06 ? 1 : -1] array2;
  float[distance(pow(vec2(1.3333334, 1.3333334), vec2(-2.0, -0.6666667)), vec2(0.56249994, 0.8254818)) <= 9.989126e-06 ? 1 : -1] array3;
  float[distance(pow(vec2(1.3333334, 1.3333334), vec2(0.6666667, 2.0)), vec2(1.2114137, 1.7777779)) <= 2.1512828e-05 ? 1 : -1] array4;
  float[distance(pow(vec2(2.0, 2.0), vec2(-2.0, -0.6666667)), vec2(0.25, 0.62996054)) <= 6.777538e-06 ? 1 : -1] array5;
  float[distance(pow(vec2(2.0, 2.0), vec2(0.6666667, 2.0)), vec2(1.587401, 4.0)) <= 4.3034684e-05 ? 1 : -1] array6;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length());
}
