/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l - i64vec2(-10l, -12l)) => i64vec2(10l, 12l)
 * (0l - i64vec2(-42l, 48l)) => i64vec2(42l, -48l)
 * (3l - i64vec2(-10l, -12l)) => i64vec2(13l, 15l)
 * (3l - i64vec2(-42l, 48l)) => i64vec2(45l, -45l)
 * (-1192l - i64vec2(-10l, -12l)) => i64vec2(-1182l, -1180l)
 * (-1192l - i64vec2(-42l, 48l)) => i64vec2(-1150l, -1240l)
 * (1048576l - i64vec2(-10l, -12l)) => i64vec2(1048586l, 1048588l)
 * (1048576l - i64vec2(-42l, 48l)) => i64vec2(1048618l, 1048528l)
 * (4251475l - i64vec2(-10l, -12l)) => i64vec2(4251485l, 4251487l)
 * (4251475l - i64vec2(-42l, 48l)) => i64vec2(4251517l, 4251427l)
 * (29852643761l - i64vec2(-10l, -12l)) => i64vec2(29852643771l, 29852643773l)
 * (29852643761l - i64vec2(-42l, 48l)) => i64vec2(29852643803l, 29852643713l)
 * (-4398046511104l - i64vec2(-10l, -12l)) => i64vec2(-4398046511094l, -4398046511092l)
 * (-4398046511104l - i64vec2(-42l, 48l)) => i64vec2(-4398046511062l, -4398046511152l)
 * (-3948976685146l - i64vec2(-10l, -12l)) => i64vec2(-3948976685136l, -3948976685134l)
 * (-3948976685146l - i64vec2(-42l, 48l)) => i64vec2(-3948976685104l, -3948976685194l)
 * (-135763469567146206l - i64vec2(-10l, -12l)) => i64vec2(-135763469567146196l, -135763469567146194l)
 * (-135763469567146206l - i64vec2(-42l, 48l)) => i64vec2(-135763469567146164l, -135763469567146254l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0l - i64vec2(-10l, -12l)), i64vec2(10l, 12l))) ? 1 : -1] array0;
  float[all(equal((0l - i64vec2(-42l, 48l)), i64vec2(42l, -48l))) ? 1 : -1] array1;
  float[all(equal((3l - i64vec2(-10l, -12l)), i64vec2(13l, 15l))) ? 1 : -1] array2;
  float[all(equal((3l - i64vec2(-42l, 48l)), i64vec2(45l, -45l))) ? 1 : -1] array3;
  float[all(equal((-1192l - i64vec2(-10l, -12l)), i64vec2(-1182l, -1180l))) ? 1 : -1] array4;
  float[all(equal((-1192l - i64vec2(-42l, 48l)), i64vec2(-1150l, -1240l))) ? 1 : -1] array5;
  float[all(equal((1048576l - i64vec2(-10l, -12l)), i64vec2(1048586l, 1048588l))) ? 1 : -1] array6;
  float[all(equal((1048576l - i64vec2(-42l, 48l)), i64vec2(1048618l, 1048528l))) ? 1 : -1] array7;
  float[all(equal((4251475l - i64vec2(-10l, -12l)), i64vec2(4251485l, 4251487l))) ? 1 : -1] array8;
  float[all(equal((4251475l - i64vec2(-42l, 48l)), i64vec2(4251517l, 4251427l))) ? 1 : -1] array9;
  float[all(equal((29852643761l - i64vec2(-10l, -12l)), i64vec2(29852643771l, 29852643773l))) ? 1 : -1] array10;
  float[all(equal((29852643761l - i64vec2(-42l, 48l)), i64vec2(29852643803l, 29852643713l))) ? 1 : -1] array11;
  float[all(equal((-4398046511104l - i64vec2(-10l, -12l)), i64vec2(-4398046511094l, -4398046511092l))) ? 1 : -1] array12;
  float[all(equal((-4398046511104l - i64vec2(-42l, 48l)), i64vec2(-4398046511062l, -4398046511152l))) ? 1 : -1] array13;
  float[all(equal((-3948976685146l - i64vec2(-10l, -12l)), i64vec2(-3948976685136l, -3948976685134l))) ? 1 : -1] array14;
  float[all(equal((-3948976685146l - i64vec2(-42l, 48l)), i64vec2(-3948976685104l, -3948976685194l))) ? 1 : -1] array15;
  float[all(equal((-135763469567146206l - i64vec2(-10l, -12l)), i64vec2(-135763469567146196l, -135763469567146194l))) ? 1 : -1] array16;
  float[all(equal((-135763469567146206l - i64vec2(-42l, 48l)), i64vec2(-135763469567146164l, -135763469567146254l))) ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
