"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProxyAuthRoutes = void 0;
var _configSchema = require("@osd/config-schema");
var _next_url = require("../../../utils/next_url");
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

class ProxyAuthRoutes {
  constructor(router, config, sessionStorageFactory, securityClient, coreSetup) {
    this.router = router;
    this.config = config;
    this.sessionStorageFactory = sessionStorageFactory;
    this.securityClient = securityClient;
    this.coreSetup = coreSetup;
  }
  setupRoutes() {
    this.router.get({
      path: `/auth/proxy/login`,
      validate: {
        query: _configSchema.schema.object({
          nextUrl: _configSchema.schema.maybe(_configSchema.schema.string({
            validate: nexturl => {
              return (0, _next_url.validateNextUrl)(nexturl, this.coreSetup.http.basePath.serverBasePath);
            }
          }))
        })
      },
      options: {
        // TODO: set to false?
        authRequired: 'optional'
      }
    }, async (context, request, response) => {
      var _this$config$proxycac;
      if (request.auth.isAuthenticated) {
        const nextUrl = request.query.nextUrl || `${this.coreSetup.http.basePath.serverBasePath}/app/opensearch-dashboards`;
        response.redirected({
          headers: {
            location: nextUrl
          }
        });
      }
      const loginEndpoint = (_this$config$proxycac = this.config.proxycache) === null || _this$config$proxycac === void 0 ? void 0 : _this$config$proxycac.login_endpoint;
      if (loginEndpoint) {
        return response.redirected({
          headers: {
            location: loginEndpoint
          }
        });
      } else {
        return response.badRequest();
      }
    });
    this.router.post({
      path: `/auth/proxy/logout`,
      validate: false
    }, async (context, request, response) => {
      this.sessionStorageFactory.asScoped(request).clear();
      return response.ok();
    });
  }
}
exports.ProxyAuthRoutes = ProxyAuthRoutes;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9uZXh0X3VybCIsIlByb3h5QXV0aFJvdXRlcyIsImNvbnN0cnVjdG9yIiwicm91dGVyIiwiY29uZmlnIiwic2Vzc2lvblN0b3JhZ2VGYWN0b3J5Iiwic2VjdXJpdHlDbGllbnQiLCJjb3JlU2V0dXAiLCJzZXR1cFJvdXRlcyIsImdldCIsInBhdGgiLCJ2YWxpZGF0ZSIsInF1ZXJ5Iiwic2NoZW1hIiwib2JqZWN0IiwibmV4dFVybCIsIm1heWJlIiwic3RyaW5nIiwibmV4dHVybCIsInZhbGlkYXRlTmV4dFVybCIsImh0dHAiLCJiYXNlUGF0aCIsInNlcnZlckJhc2VQYXRoIiwib3B0aW9ucyIsImF1dGhSZXF1aXJlZCIsImNvbnRleHQiLCJyZXF1ZXN0IiwicmVzcG9uc2UiLCJfdGhpcyRjb25maWckcHJveHljYWMiLCJhdXRoIiwiaXNBdXRoZW50aWNhdGVkIiwicmVkaXJlY3RlZCIsImhlYWRlcnMiLCJsb2NhdGlvbiIsImxvZ2luRW5kcG9pbnQiLCJwcm94eWNhY2hlIiwibG9naW5fZW5kcG9pbnQiLCJiYWRSZXF1ZXN0IiwicG9zdCIsImFzU2NvcGVkIiwiY2xlYXIiLCJvayIsImV4cG9ydHMiXSwic291cmNlcyI6WyJyb3V0ZXMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqICAgQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKlxuICogICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLlxuICogICBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGggdGhlIExpY2Vuc2UuXG4gKiAgIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogICBvciBpbiB0aGUgXCJsaWNlbnNlXCIgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWRcbiAqICAgb24gYW4gXCJBUyBJU1wiIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVMgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZWl0aGVyXG4gKiAgIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nXG4gKiAgIHBlcm1pc3Npb25zIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgeyBzY2hlbWEgfSBmcm9tICdAb3NkL2NvbmZpZy1zY2hlbWEnO1xuaW1wb3J0IHsgSVJvdXRlciwgU2Vzc2lvblN0b3JhZ2VGYWN0b3J5IH0gZnJvbSAnLi4vLi4vLi4vLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcbmltcG9ydCB7IFNlY3VyaXR5U2Vzc2lvbkNvb2tpZSB9IGZyb20gJy4uLy4uLy4uL3Nlc3Npb24vc2VjdXJpdHlfY29va2llJztcbmltcG9ydCB7IFNlY3VyaXR5UGx1Z2luQ29uZmlnVHlwZSB9IGZyb20gJy4uLy4uLy4uJztcbmltcG9ydCB7IFNlY3VyaXR5Q2xpZW50IH0gZnJvbSAnLi4vLi4vLi4vYmFja2VuZC9vcGVuc2VhcmNoX3NlY3VyaXR5X2NsaWVudCc7XG5pbXBvcnQgeyBDb3JlU2V0dXAgfSBmcm9tICcuLi8uLi8uLi8uLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXInO1xuaW1wb3J0IHsgdmFsaWRhdGVOZXh0VXJsIH0gZnJvbSAnLi4vLi4vLi4vdXRpbHMvbmV4dF91cmwnO1xuXG5leHBvcnQgY2xhc3MgUHJveHlBdXRoUm91dGVzIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSByZWFkb25seSByb3V0ZXI6IElSb3V0ZXIsXG4gICAgcHJpdmF0ZSByZWFkb25seSBjb25maWc6IFNlY3VyaXR5UGx1Z2luQ29uZmlnVHlwZSxcbiAgICBwcml2YXRlIHJlYWRvbmx5IHNlc3Npb25TdG9yYWdlRmFjdG9yeTogU2Vzc2lvblN0b3JhZ2VGYWN0b3J5PFNlY3VyaXR5U2Vzc2lvbkNvb2tpZT4sXG4gICAgcHJpdmF0ZSByZWFkb25seSBzZWN1cml0eUNsaWVudDogU2VjdXJpdHlDbGllbnQsXG4gICAgcHJpdmF0ZSByZWFkb25seSBjb3JlU2V0dXA6IENvcmVTZXR1cFxuICApIHt9XG5cbiAgcHVibGljIHNldHVwUm91dGVzKCkge1xuICAgIHRoaXMucm91dGVyLmdldChcbiAgICAgIHtcbiAgICAgICAgcGF0aDogYC9hdXRoL3Byb3h5L2xvZ2luYCxcbiAgICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgICBxdWVyeTogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgICAgICBuZXh0VXJsOiBzY2hlbWEubWF5YmUoXG4gICAgICAgICAgICAgIHNjaGVtYS5zdHJpbmcoe1xuICAgICAgICAgICAgICAgIHZhbGlkYXRlOiAobmV4dHVybCkgPT4ge1xuICAgICAgICAgICAgICAgICAgcmV0dXJuIHZhbGlkYXRlTmV4dFVybChuZXh0dXJsLCB0aGlzLmNvcmVTZXR1cC5odHRwLmJhc2VQYXRoLnNlcnZlckJhc2VQYXRoKTtcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgKSxcbiAgICAgICAgICB9KSxcbiAgICAgICAgfSxcbiAgICAgICAgb3B0aW9uczoge1xuICAgICAgICAgIC8vIFRPRE86IHNldCB0byBmYWxzZT9cbiAgICAgICAgICBhdXRoUmVxdWlyZWQ6ICdvcHRpb25hbCcsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAgYXN5bmMgKGNvbnRleHQsIHJlcXVlc3QsIHJlc3BvbnNlKSA9PiB7XG4gICAgICAgIGlmIChyZXF1ZXN0LmF1dGguaXNBdXRoZW50aWNhdGVkKSB7XG4gICAgICAgICAgY29uc3QgbmV4dFVybCA9XG4gICAgICAgICAgICByZXF1ZXN0LnF1ZXJ5Lm5leHRVcmwgfHxcbiAgICAgICAgICAgIGAke3RoaXMuY29yZVNldHVwLmh0dHAuYmFzZVBhdGguc2VydmVyQmFzZVBhdGh9L2FwcC9vcGVuc2VhcmNoLWRhc2hib2FyZHNgO1xuICAgICAgICAgIHJlc3BvbnNlLnJlZGlyZWN0ZWQoe1xuICAgICAgICAgICAgaGVhZGVyczoge1xuICAgICAgICAgICAgICBsb2NhdGlvbjogbmV4dFVybCxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSk7XG4gICAgICAgIH1cblxuICAgICAgICBjb25zdCBsb2dpbkVuZHBvaW50ID0gdGhpcy5jb25maWcucHJveHljYWNoZT8ubG9naW5fZW5kcG9pbnQ7XG4gICAgICAgIGlmIChsb2dpbkVuZHBvaW50KSB7XG4gICAgICAgICAgcmV0dXJuIHJlc3BvbnNlLnJlZGlyZWN0ZWQoe1xuICAgICAgICAgICAgaGVhZGVyczoge1xuICAgICAgICAgICAgICBsb2NhdGlvbjogbG9naW5FbmRwb2ludCxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSk7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmJhZFJlcXVlc3QoKTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgICk7XG5cbiAgICB0aGlzLnJvdXRlci5wb3N0KFxuICAgICAge1xuICAgICAgICBwYXRoOiBgL2F1dGgvcHJveHkvbG9nb3V0YCxcbiAgICAgICAgdmFsaWRhdGU6IGZhbHNlLFxuICAgICAgfSxcbiAgICAgIGFzeW5jIChjb250ZXh0LCByZXF1ZXN0LCByZXNwb25zZSkgPT4ge1xuICAgICAgICB0aGlzLnNlc3Npb25TdG9yYWdlRmFjdG9yeS5hc1Njb3BlZChyZXF1ZXN0KS5jbGVhcigpO1xuICAgICAgICByZXR1cm4gcmVzcG9uc2Uub2soKTtcbiAgICAgIH1cbiAgICApO1xuICB9XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQWVBLElBQUFBLGFBQUEsR0FBQUMsT0FBQTtBQU1BLElBQUFDLFNBQUEsR0FBQUQsT0FBQTtBQXJCQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQVVPLE1BQU1FLGVBQWUsQ0FBQztFQUMzQkMsV0FBV0EsQ0FDUUMsTUFBZSxFQUNmQyxNQUFnQyxFQUNoQ0MscUJBQW1FLEVBQ25FQyxjQUE4QixFQUM5QkMsU0FBb0IsRUFDckM7SUFBQSxLQUxpQkosTUFBZSxHQUFmQSxNQUFlO0lBQUEsS0FDZkMsTUFBZ0MsR0FBaENBLE1BQWdDO0lBQUEsS0FDaENDLHFCQUFtRSxHQUFuRUEscUJBQW1FO0lBQUEsS0FDbkVDLGNBQThCLEdBQTlCQSxjQUE4QjtJQUFBLEtBQzlCQyxTQUFvQixHQUFwQkEsU0FBb0I7RUFDcEM7RUFFSUMsV0FBV0EsQ0FBQSxFQUFHO0lBQ25CLElBQUksQ0FBQ0wsTUFBTSxDQUFDTSxHQUFHLENBQ2I7TUFDRUMsSUFBSSxFQUFHLG1CQUFrQjtNQUN6QkMsUUFBUSxFQUFFO1FBQ1JDLEtBQUssRUFBRUMsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO1VBQ25CQyxPQUFPLEVBQUVGLG9CQUFNLENBQUNHLEtBQUssQ0FDbkJILG9CQUFNLENBQUNJLE1BQU0sQ0FBQztZQUNaTixRQUFRLEVBQUdPLE9BQU8sSUFBSztjQUNyQixPQUFPLElBQUFDLHlCQUFlLEVBQUNELE9BQU8sRUFBRSxJQUFJLENBQUNYLFNBQVMsQ0FBQ2EsSUFBSSxDQUFDQyxRQUFRLENBQUNDLGNBQWMsQ0FBQztZQUM5RTtVQUNGLENBQUMsQ0FDSDtRQUNGLENBQUM7TUFDSCxDQUFDO01BQ0RDLE9BQU8sRUFBRTtRQUNQO1FBQ0FDLFlBQVksRUFBRTtNQUNoQjtJQUNGLENBQUMsRUFDRCxPQUFPQyxPQUFPLEVBQUVDLE9BQU8sRUFBRUMsUUFBUSxLQUFLO01BQUEsSUFBQUMscUJBQUE7TUFDcEMsSUFBSUYsT0FBTyxDQUFDRyxJQUFJLENBQUNDLGVBQWUsRUFBRTtRQUNoQyxNQUFNZixPQUFPLEdBQ1hXLE9BQU8sQ0FBQ2QsS0FBSyxDQUFDRyxPQUFPLElBQ3BCLEdBQUUsSUFBSSxDQUFDUixTQUFTLENBQUNhLElBQUksQ0FBQ0MsUUFBUSxDQUFDQyxjQUFlLDRCQUEyQjtRQUM1RUssUUFBUSxDQUFDSSxVQUFVLENBQUM7VUFDbEJDLE9BQU8sRUFBRTtZQUNQQyxRQUFRLEVBQUVsQjtVQUNaO1FBQ0YsQ0FBQyxDQUFDO01BQ0o7TUFFQSxNQUFNbUIsYUFBYSxJQUFBTixxQkFBQSxHQUFHLElBQUksQ0FBQ3hCLE1BQU0sQ0FBQytCLFVBQVUsY0FBQVAscUJBQUEsdUJBQXRCQSxxQkFBQSxDQUF3QlEsY0FBYztNQUM1RCxJQUFJRixhQUFhLEVBQUU7UUFDakIsT0FBT1AsUUFBUSxDQUFDSSxVQUFVLENBQUM7VUFDekJDLE9BQU8sRUFBRTtZQUNQQyxRQUFRLEVBQUVDO1VBQ1o7UUFDRixDQUFDLENBQUM7TUFDSixDQUFDLE1BQU07UUFDTCxPQUFPUCxRQUFRLENBQUNVLFVBQVUsQ0FBQyxDQUFDO01BQzlCO0lBQ0YsQ0FDRixDQUFDO0lBRUQsSUFBSSxDQUFDbEMsTUFBTSxDQUFDbUMsSUFBSSxDQUNkO01BQ0U1QixJQUFJLEVBQUcsb0JBQW1CO01BQzFCQyxRQUFRLEVBQUU7SUFDWixDQUFDLEVBQ0QsT0FBT2MsT0FBTyxFQUFFQyxPQUFPLEVBQUVDLFFBQVEsS0FBSztNQUNwQyxJQUFJLENBQUN0QixxQkFBcUIsQ0FBQ2tDLFFBQVEsQ0FBQ2IsT0FBTyxDQUFDLENBQUNjLEtBQUssQ0FBQyxDQUFDO01BQ3BELE9BQU9iLFFBQVEsQ0FBQ2MsRUFBRSxDQUFDLENBQUM7SUFDdEIsQ0FDRixDQUFDO0VBQ0g7QUFDRjtBQUFDQyxPQUFBLENBQUF6QyxlQUFBLEdBQUFBLGVBQUEifQ==