"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalTenantName = exports.SAML_AUTH_LOGOUT = exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = exports.SAML_AUTH_LOGIN = exports.ResourceType = exports.PRIVATE_TENANT_SYMBOL = exports.PRIVATE_TENANT_RENDERING_TEXT = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OPENID_AUTH_LOGOUT = exports.OPENID_AUTH_LOGIN_WITH_FRAGMENT = exports.OPENID_AUTH_LOGIN = exports.OPENDISTRO_SECURITY_ANONYMOUS = exports.MAX_LENGTH_OF_COOKIE_BYTES = exports.MAX_INTEGER = exports.LOGIN_PAGE_URI = exports.LOCAL_CLUSTER_ID = exports.GLOBAL_TENANT_SYMBOL = exports.GLOBAL_TENANT_RENDERING_TEXT = exports.ESTIMATED_IRON_COOKIE_OVERHEAD = exports.ERROR_MISSING_ROLE_PATH = exports.DEFAULT_TENANT = exports.CUSTOM_ERROR_PAGE_URI = exports.CONFIGURATION_API_PREFIX = exports.AuthType = exports.AUTH_TYPE_PARAM = exports.AUTH_RESPONSE_TYPE = exports.AUTH_HEADER_NAME = exports.AUTH_GRANT_TYPE = exports.APP_ID_LOGIN = exports.APP_ID_CUSTOMERROR = exports.API_PREFIX = exports.API_ENDPOINT_DASHBOARDSINFO = exports.API_ENDPOINT_AUTHTYPE = exports.API_ENDPOINT_AUTHINFO = exports.API_AUTH_LOGOUT = exports.API_AUTH_LOGIN = exports.ANONYMOUS_AUTH_LOGOUT = exports.ANONYMOUS_AUTH_LOGIN = void 0;
exports.isGlobalTenant = isGlobalTenant;
exports.isPrivateTenant = isPrivateTenant;
exports.isRenderingPrivateTenant = isRenderingPrivateTenant;
exports.isValidResourceName = isValidResourceName;
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'opensearchDashboardsSecurity';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'security-dashboards-plugin';
const APP_ID_LOGIN = exports.APP_ID_LOGIN = 'login';
const APP_ID_CUSTOMERROR = exports.APP_ID_CUSTOMERROR = 'customerror';
const OPENDISTRO_SECURITY_ANONYMOUS = exports.OPENDISTRO_SECURITY_ANONYMOUS = 'opendistro_security_anonymous';
const API_PREFIX = exports.API_PREFIX = '/api/v1';
const CONFIGURATION_API_PREFIX = exports.CONFIGURATION_API_PREFIX = 'configuration';
const API_ENDPOINT_AUTHINFO = exports.API_ENDPOINT_AUTHINFO = API_PREFIX + '/auth/authinfo';
const API_ENDPOINT_DASHBOARDSINFO = exports.API_ENDPOINT_DASHBOARDSINFO = API_PREFIX + '/auth/dashboardsinfo';
const API_ENDPOINT_AUTHTYPE = exports.API_ENDPOINT_AUTHTYPE = API_PREFIX + '/auth/type';
const LOGIN_PAGE_URI = exports.LOGIN_PAGE_URI = '/app/' + APP_ID_LOGIN;
const CUSTOM_ERROR_PAGE_URI = exports.CUSTOM_ERROR_PAGE_URI = '/app/' + APP_ID_CUSTOMERROR;
const API_AUTH_LOGIN = exports.API_AUTH_LOGIN = '/auth/login';
const API_AUTH_LOGOUT = exports.API_AUTH_LOGOUT = '/auth/logout';
const OPENID_AUTH_LOGIN = exports.OPENID_AUTH_LOGIN = '/auth/openid/login';
const OPENID_AUTH_LOGIN_WITH_FRAGMENT = exports.OPENID_AUTH_LOGIN_WITH_FRAGMENT = '/auth/openid/captureUrlFragment';
const SAML_AUTH_LOGIN = exports.SAML_AUTH_LOGIN = '/auth/saml/login';
const SAML_AUTH_LOGIN_WITH_FRAGMENT = exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = '/auth/saml/captureUrlFragment';
const ANONYMOUS_AUTH_LOGIN = exports.ANONYMOUS_AUTH_LOGIN = '/auth/anonymous';
const AUTH_TYPE_PARAM = exports.AUTH_TYPE_PARAM = 'auth_type';
const OPENID_AUTH_LOGOUT = exports.OPENID_AUTH_LOGOUT = '/auth/openid/logout';
const SAML_AUTH_LOGOUT = exports.SAML_AUTH_LOGOUT = '/auth/saml/logout';
const ANONYMOUS_AUTH_LOGOUT = exports.ANONYMOUS_AUTH_LOGOUT = '/auth/anonymous/logout';
const ERROR_MISSING_ROLE_PATH = exports.ERROR_MISSING_ROLE_PATH = '/missing-role';
const AUTH_HEADER_NAME = exports.AUTH_HEADER_NAME = 'authorization';
const AUTH_GRANT_TYPE = exports.AUTH_GRANT_TYPE = 'authorization_code';
const AUTH_RESPONSE_TYPE = exports.AUTH_RESPONSE_TYPE = 'code';
const GLOBAL_TENANT_SYMBOL = exports.GLOBAL_TENANT_SYMBOL = '';
const PRIVATE_TENANT_SYMBOL = exports.PRIVATE_TENANT_SYMBOL = '__user__';
const DEFAULT_TENANT = exports.DEFAULT_TENANT = 'default';
const GLOBAL_TENANT_RENDERING_TEXT = exports.GLOBAL_TENANT_RENDERING_TEXT = 'Global';
const PRIVATE_TENANT_RENDERING_TEXT = exports.PRIVATE_TENANT_RENDERING_TEXT = 'Private';
const globalTenantName = exports.globalTenantName = 'global_tenant';
const MAX_INTEGER = exports.MAX_INTEGER = 2147483647;
const MAX_LENGTH_OF_COOKIE_BYTES = exports.MAX_LENGTH_OF_COOKIE_BYTES = 4000;
const ESTIMATED_IRON_COOKIE_OVERHEAD = exports.ESTIMATED_IRON_COOKIE_OVERHEAD = 1.5;
const LOCAL_CLUSTER_ID = exports.LOCAL_CLUSTER_ID = '';
let AuthType = exports.AuthType = /*#__PURE__*/function (AuthType) {
  AuthType["BASIC"] = "basicauth";
  AuthType["OPEN_ID"] = "openid";
  AuthType["JWT"] = "jwt";
  AuthType["SAML"] = "saml";
  AuthType["PROXY"] = "proxy";
  AuthType["ANONYMOUS"] = "anonymous";
  return AuthType;
}({});
let ResourceType = exports.ResourceType = /*#__PURE__*/function (ResourceType) {
  ResourceType["roles"] = "roles";
  ResourceType["users"] = "users";
  ResourceType["permissions"] = "permissions";
  ResourceType["tenants"] = "tenants";
  ResourceType["tenantsManageTab"] = "tenantsManageTab";
  ResourceType["tenantsConfigureTab"] = "tenantsConfigureTab";
  ResourceType["auth"] = "auth";
  ResourceType["auditLogging"] = "auditLogging";
  return ResourceType;
}({});
/**
 * A valid resource name should not containing percent sign (%) as they raise url injection issue.
 * And also should not be empty.
 * @param resourceName resource name to be validated
 */
function isValidResourceName(resourceName) {
  // see: https://javascript.info/regexp-unicode
  const exp = new RegExp('[\\p{C}%]', 'u');
  return !exp.test(resourceName) && resourceName.length > 0;
}
function isPrivateTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === PRIVATE_TENANT_SYMBOL;
}
function isRenderingPrivateTenant(selectedTenant) {
  return selectedTenant !== null && (selectedTenant === null || selectedTenant === void 0 ? void 0 : selectedTenant.startsWith(PRIVATE_TENANT_SYMBOL));
}
function isGlobalTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === GLOBAL_TENANT_SYMBOL;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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