"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addFieldMappingMethods = addFieldMappingMethods;
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function addFieldMappingMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.GET_MAPPINGS_VIEW] = createAction({
    url: {
      fmt: `${_constants.API.MAPPINGS_VIEW}?index_name=<%=indexName%>&rule_topic=<%=ruleTopic%>`,
      req: {
        indexName: {
          type: 'string',
          required: true
        },
        ruleTopic: {
          type: 'string',
          required: false
        }
      }
    },
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.CREATE_MAPPINGS] = createAction({
    url: {
      fmt: `${_constants.API.MAPPINGS_BASE}`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_MAPPINGS] = createAction({
    url: {
      fmt: `${_constants.API.MAPPINGS_BASE}?index_name=<%=indexName%>`,
      req: {
        indexName: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_INDEX_ALIAS_MAPPINGS] = createAction({
    url: {
      fmt: `/<%=indexName%>/_mapping`,
      req: {
        indexName: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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