"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addCorrelationMethods = addCorrelationMethods;
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function addCorrelationMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.GET_CORRELATION_RULES] = createAction({
    url: {
      fmt: `${_constants.API.CORRELATION_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.CREATE_CORRELATION_RULE] = createAction({
    url: {
      fmt: `${_constants.API.CORRELATION_BASE}`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.UPDATE_CORRELATION_RULE] = createAction({
    url: {
      fmt: `${_constants.API.CORRELATION_BASE}/<%=ruleId%>`,
      req: {
        ruleId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  securityAnalytics[_constants.METHOD_NAMES.DELETE_CORRELATION_RULE] = createAction({
    url: {
      fmt: `${_constants.API.CORRELATION_BASE}/<%=ruleId%>`,
      req: {
        ruleId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'DELETE'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_CORRELATED_FINDINGS] = createAction({
    url: {
      fmt: `${_constants.API.FINDINGS_BASE}/correlate?finding=<%=finding%>&detector_type=<%=detector_type%>&nearby_findings=<%=nearby_findings%>`,
      req: {
        finding: {
          type: 'string',
          required: true
        },
        detector_type: {
          type: 'string',
          required: true
        },
        nearby_findings: {
          type: 'number',
          required: false
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_ALL_CORRELATIONS] = createAction({
    url: {
      fmt: `${_constants.API.CORRELATIONS}?start_timestamp=<%=start_timestamp%>&end_timestamp=<%=end_timestamp%>`,
      req: {
        start_timestamp: {
          type: 'string',
          required: true
        },
        end_timestamp: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_CORRELATION_ALERTS] = createAction({
    url: {
      fmt: `${_constants.API.GET_CORRELATION_ALERTS}`
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.ACK_CORRELATION_ALERTS] = createAction({
    url: {
      fmt: `${_constants.API.ACK_CORRELATION_ALERTS}`
    },
    needBody: true,
    method: 'POST'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uc3RhbnRzIiwicmVxdWlyZSIsImFkZENvcnJlbGF0aW9uTWV0aG9kcyIsInNlY3VyaXR5QW5hbHl0aWNzIiwiY3JlYXRlQWN0aW9uIiwiTUVUSE9EX05BTUVTIiwiR0VUX0NPUlJFTEFUSU9OX1JVTEVTIiwidXJsIiwiZm10IiwiQVBJIiwiQ09SUkVMQVRJT05fQkFTRSIsIm5lZWRCb2R5IiwibWV0aG9kIiwiQ1JFQVRFX0NPUlJFTEFUSU9OX1JVTEUiLCJVUERBVEVfQ09SUkVMQVRJT05fUlVMRSIsInJlcSIsInJ1bGVJZCIsInR5cGUiLCJyZXF1aXJlZCIsIkRFTEVURV9DT1JSRUxBVElPTl9SVUxFIiwiR0VUX0NPUlJFTEFURURfRklORElOR1MiLCJGSU5ESU5HU19CQVNFIiwiZmluZGluZyIsImRldGVjdG9yX3R5cGUiLCJuZWFyYnlfZmluZGluZ3MiLCJHRVRfQUxMX0NPUlJFTEFUSU9OUyIsIkNPUlJFTEFUSU9OUyIsInN0YXJ0X3RpbWVzdGFtcCIsImVuZF90aW1lc3RhbXAiLCJHRVRfQ09SUkVMQVRJT05fQUxFUlRTIiwiQUNLX0NPUlJFTEFUSU9OX0FMRVJUUyJdLCJzb3VyY2VzIjpbImFkZENvcnJlbGF0aW9uTWV0aG9kcy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IEFQSSwgTUVUSE9EX05BTUVTIH0gZnJvbSAnLi4vdXRpbHMvY29uc3RhbnRzJztcblxuZXhwb3J0IGZ1bmN0aW9uIGFkZENvcnJlbGF0aW9uTWV0aG9kcyhzZWN1cml0eUFuYWx5dGljczogYW55LCBjcmVhdGVBY3Rpb246IGFueSk6IHZvaWQge1xuICBzZWN1cml0eUFuYWx5dGljc1tNRVRIT0RfTkFNRVMuR0VUX0NPUlJFTEFUSU9OX1JVTEVTXSA9IGNyZWF0ZUFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke0FQSS5DT1JSRUxBVElPTl9CQVNFfS9fc2VhcmNoYCxcbiAgICB9LFxuICAgIG5lZWRCb2R5OiB0cnVlLFxuICAgIG1ldGhvZDogJ1BPU1QnLFxuICB9KTtcblxuICBzZWN1cml0eUFuYWx5dGljc1tNRVRIT0RfTkFNRVMuQ1JFQVRFX0NPUlJFTEFUSU9OX1JVTEVdID0gY3JlYXRlQWN0aW9uKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogYCR7QVBJLkNPUlJFTEFUSU9OX0JBU0V9YCxcbiAgICB9LFxuICAgIG5lZWRCb2R5OiB0cnVlLFxuICAgIG1ldGhvZDogJ1BPU1QnLFxuICB9KTtcblxuICBzZWN1cml0eUFuYWx5dGljc1tNRVRIT0RfTkFNRVMuVVBEQVRFX0NPUlJFTEFUSU9OX1JVTEVdID0gY3JlYXRlQWN0aW9uKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogYCR7QVBJLkNPUlJFTEFUSU9OX0JBU0V9LzwlPXJ1bGVJZCU+YCxcbiAgICAgIHJlcToge1xuICAgICAgICBydWxlSWQ6IHtcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICByZXF1aXJlZDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBuZWVkQm9keTogdHJ1ZSxcbiAgICBtZXRob2Q6ICdQVVQnLFxuICB9KTtcblxuICBzZWN1cml0eUFuYWx5dGljc1tNRVRIT0RfTkFNRVMuREVMRVRFX0NPUlJFTEFUSU9OX1JVTEVdID0gY3JlYXRlQWN0aW9uKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogYCR7QVBJLkNPUlJFTEFUSU9OX0JBU0V9LzwlPXJ1bGVJZCU+YCxcbiAgICAgIHJlcToge1xuICAgICAgICBydWxlSWQ6IHtcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICByZXF1aXJlZDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBuZWVkQm9keTogZmFsc2UsXG4gICAgbWV0aG9kOiAnREVMRVRFJyxcbiAgfSk7XG5cbiAgc2VjdXJpdHlBbmFseXRpY3NbTUVUSE9EX05BTUVTLkdFVF9DT1JSRUxBVEVEX0ZJTkRJTkdTXSA9IGNyZWF0ZUFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke0FQSS5GSU5ESU5HU19CQVNFfS9jb3JyZWxhdGU/ZmluZGluZz08JT1maW5kaW5nJT4mZGV0ZWN0b3JfdHlwZT08JT1kZXRlY3Rvcl90eXBlJT4mbmVhcmJ5X2ZpbmRpbmdzPTwlPW5lYXJieV9maW5kaW5ncyU+YCxcbiAgICAgIHJlcToge1xuICAgICAgICBmaW5kaW5nOiB7XG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgcmVxdWlyZWQ6IHRydWUsXG4gICAgICAgIH0sXG4gICAgICAgIGRldGVjdG9yX3R5cGU6IHtcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICByZXF1aXJlZDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgICAgbmVhcmJ5X2ZpbmRpbmdzOiB7XG4gICAgICAgICAgdHlwZTogJ251bWJlcicsXG4gICAgICAgICAgcmVxdWlyZWQ6IGZhbHNlLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9LFxuICAgIG5lZWRCb2R5OiBmYWxzZSxcbiAgICBtZXRob2Q6ICdHRVQnLFxuICB9KTtcblxuICBzZWN1cml0eUFuYWx5dGljc1tNRVRIT0RfTkFNRVMuR0VUX0FMTF9DT1JSRUxBVElPTlNdID0gY3JlYXRlQWN0aW9uKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogYCR7QVBJLkNPUlJFTEFUSU9OU30/c3RhcnRfdGltZXN0YW1wPTwlPXN0YXJ0X3RpbWVzdGFtcCU+JmVuZF90aW1lc3RhbXA9PCU9ZW5kX3RpbWVzdGFtcCU+YCxcbiAgICAgIHJlcToge1xuICAgICAgICBzdGFydF90aW1lc3RhbXA6IHtcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICByZXF1aXJlZDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgICAgZW5kX3RpbWVzdGFtcDoge1xuICAgICAgICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgICAgICAgIHJlcXVpcmVkOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9LFxuICAgIG5lZWRCb2R5OiBmYWxzZSxcbiAgICBtZXRob2Q6ICdHRVQnLFxuICB9KTtcblxuICBzZWN1cml0eUFuYWx5dGljc1tNRVRIT0RfTkFNRVMuR0VUX0NPUlJFTEFUSU9OX0FMRVJUU10gPSBjcmVhdGVBY3Rpb24oe1xuICAgIHVybDoge1xuICAgICAgZm10OiBgJHtBUEkuR0VUX0NPUlJFTEFUSU9OX0FMRVJUU31gLFxuICAgIH0sXG4gICAgbmVlZEJvZHk6IGZhbHNlLFxuICAgIG1ldGhvZDogJ0dFVCcsXG4gIH0pO1xuXG4gIHNlY3VyaXR5QW5hbHl0aWNzW01FVEhPRF9OQU1FUy5BQ0tfQ09SUkVMQVRJT05fQUxFUlRTXSA9IGNyZWF0ZUFjdGlvbih7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke0FQSS5BQ0tfQ09SUkVMQVRJT05fQUxFUlRTfWAsXG4gICAgfSxcbiAgICBuZWVkQm9keTogdHJ1ZSxcbiAgICBtZXRob2Q6ICdQT1NUJyxcbiAgfSk7XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLFVBQUEsR0FBQUMsT0FBQTtBQUxBO0FBQ0E7QUFDQTtBQUNBOztBQUlPLFNBQVNDLHFCQUFxQkEsQ0FBQ0MsaUJBQXNCLEVBQUVDLFlBQWlCLEVBQVE7RUFDckZELGlCQUFpQixDQUFDRSx1QkFBWSxDQUFDQyxxQkFBcUIsQ0FBQyxHQUFHRixZQUFZLENBQUM7SUFDbkVHLEdBQUcsRUFBRTtNQUNIQyxHQUFHLEVBQUcsR0FBRUMsY0FBRyxDQUFDQyxnQkFBaUI7SUFDL0IsQ0FBQztJQUNEQyxRQUFRLEVBQUUsSUFBSTtJQUNkQyxNQUFNLEVBQUU7RUFDVixDQUFDLENBQUM7RUFFRlQsaUJBQWlCLENBQUNFLHVCQUFZLENBQUNRLHVCQUF1QixDQUFDLEdBQUdULFlBQVksQ0FBQztJQUNyRUcsR0FBRyxFQUFFO01BQ0hDLEdBQUcsRUFBRyxHQUFFQyxjQUFHLENBQUNDLGdCQUFpQjtJQUMvQixDQUFDO0lBQ0RDLFFBQVEsRUFBRSxJQUFJO0lBQ2RDLE1BQU0sRUFBRTtFQUNWLENBQUMsQ0FBQztFQUVGVCxpQkFBaUIsQ0FBQ0UsdUJBQVksQ0FBQ1MsdUJBQXVCLENBQUMsR0FBR1YsWUFBWSxDQUFDO0lBQ3JFRyxHQUFHLEVBQUU7TUFDSEMsR0FBRyxFQUFHLEdBQUVDLGNBQUcsQ0FBQ0MsZ0JBQWlCLGNBQWE7TUFDMUNLLEdBQUcsRUFBRTtRQUNIQyxNQUFNLEVBQUU7VUFDTkMsSUFBSSxFQUFFLFFBQVE7VUFDZEMsUUFBUSxFQUFFO1FBQ1o7TUFDRjtJQUNGLENBQUM7SUFDRFAsUUFBUSxFQUFFLElBQUk7SUFDZEMsTUFBTSxFQUFFO0VBQ1YsQ0FBQyxDQUFDO0VBRUZULGlCQUFpQixDQUFDRSx1QkFBWSxDQUFDYyx1QkFBdUIsQ0FBQyxHQUFHZixZQUFZLENBQUM7SUFDckVHLEdBQUcsRUFBRTtNQUNIQyxHQUFHLEVBQUcsR0FBRUMsY0FBRyxDQUFDQyxnQkFBaUIsY0FBYTtNQUMxQ0ssR0FBRyxFQUFFO1FBQ0hDLE1BQU0sRUFBRTtVQUNOQyxJQUFJLEVBQUUsUUFBUTtVQUNkQyxRQUFRLEVBQUU7UUFDWjtNQUNGO0lBQ0YsQ0FBQztJQUNEUCxRQUFRLEVBQUUsS0FBSztJQUNmQyxNQUFNLEVBQUU7RUFDVixDQUFDLENBQUM7RUFFRlQsaUJBQWlCLENBQUNFLHVCQUFZLENBQUNlLHVCQUF1QixDQUFDLEdBQUdoQixZQUFZLENBQUM7SUFDckVHLEdBQUcsRUFBRTtNQUNIQyxHQUFHLEVBQUcsR0FBRUMsY0FBRyxDQUFDWSxhQUFjLHVHQUFzRztNQUNoSU4sR0FBRyxFQUFFO1FBQ0hPLE9BQU8sRUFBRTtVQUNQTCxJQUFJLEVBQUUsUUFBUTtVQUNkQyxRQUFRLEVBQUU7UUFDWixDQUFDO1FBQ0RLLGFBQWEsRUFBRTtVQUNiTixJQUFJLEVBQUUsUUFBUTtVQUNkQyxRQUFRLEVBQUU7UUFDWixDQUFDO1FBQ0RNLGVBQWUsRUFBRTtVQUNmUCxJQUFJLEVBQUUsUUFBUTtVQUNkQyxRQUFRLEVBQUU7UUFDWjtNQUNGO0lBQ0YsQ0FBQztJQUNEUCxRQUFRLEVBQUUsS0FBSztJQUNmQyxNQUFNLEVBQUU7RUFDVixDQUFDLENBQUM7RUFFRlQsaUJBQWlCLENBQUNFLHVCQUFZLENBQUNvQixvQkFBb0IsQ0FBQyxHQUFHckIsWUFBWSxDQUFDO0lBQ2xFRyxHQUFHLEVBQUU7TUFDSEMsR0FBRyxFQUFHLEdBQUVDLGNBQUcsQ0FBQ2lCLFlBQWEsd0VBQXVFO01BQ2hHWCxHQUFHLEVBQUU7UUFDSFksZUFBZSxFQUFFO1VBQ2ZWLElBQUksRUFBRSxRQUFRO1VBQ2RDLFFBQVEsRUFBRTtRQUNaLENBQUM7UUFDRFUsYUFBYSxFQUFFO1VBQ2JYLElBQUksRUFBRSxRQUFRO1VBQ2RDLFFBQVEsRUFBRTtRQUNaO01BQ0Y7SUFDRixDQUFDO0lBQ0RQLFFBQVEsRUFBRSxLQUFLO0lBQ2ZDLE1BQU0sRUFBRTtFQUNWLENBQUMsQ0FBQztFQUVGVCxpQkFBaUIsQ0FBQ0UsdUJBQVksQ0FBQ3dCLHNCQUFzQixDQUFDLEdBQUd6QixZQUFZLENBQUM7SUFDcEVHLEdBQUcsRUFBRTtNQUNIQyxHQUFHLEVBQUcsR0FBRUMsY0FBRyxDQUFDb0Isc0JBQXVCO0lBQ3JDLENBQUM7SUFDRGxCLFFBQVEsRUFBRSxLQUFLO0lBQ2ZDLE1BQU0sRUFBRTtFQUNWLENBQUMsQ0FBQztFQUVGVCxpQkFBaUIsQ0FBQ0UsdUJBQVksQ0FBQ3lCLHNCQUFzQixDQUFDLEdBQUcxQixZQUFZLENBQUM7SUFDcEVHLEdBQUcsRUFBRTtNQUNIQyxHQUFHLEVBQUcsR0FBRUMsY0FBRyxDQUFDcUIsc0JBQXVCO0lBQ3JDLENBQUM7SUFDRG5CLFFBQVEsRUFBRSxJQUFJO0lBQ2RDLE1BQU0sRUFBRTtFQUNWLENBQUMsQ0FBQztBQUNKIn0=