"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLDataSource = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class PPLDataSource {
  constructor(pplDataSource, dataType) {
    this.pplDataSource = pplDataSource;
    this.dataType = dataType;
    _defineProperty(this, "addStatsMapping", () => {
      var _visData$metadata;
      const visData = this.pplDataSource;

      /**
       * Add vis mapping for runtime fields
       * json data structure added to response will be
       * [{
       *  agent: "mozilla",
       *  avg(bytes): 5756
       *  ...
       * }, {
       *  agent: "MSIE",
       *  avg(bytes): 5605
       *  ...
       * }, {
       *  agent: "chrome",
       *  avg(bytes): 5648
       *  ...
       * }]
       */
      const res = [];
      if (visData !== null && visData !== void 0 && (_visData$metadata = visData.metadata) !== null && _visData$metadata !== void 0 && _visData$metadata.fields) {
        const queriedFields = visData.metadata.fields;
        for (let i = 0; i < visData.size; i++) {
          const entry = {};
          queriedFields.map(field => {
            const statsDataSet = visData === null || visData === void 0 ? void 0 : visData.data;
            entry[field.name] = statsDataSet[field.name][i];
          });
          res.push(entry);
        }
        visData.jsonData = res;
      }
    });
    /**
     * Add 'schemaName: data' entries for UI rendering
     */
    _defineProperty(this, "addSchemaRowMapping", () => {
      const pplRes = this.pplDataSource;
      const data = [];
      _lodash.default.forEach(pplRes.datarows, row => {
        const record = {};
        for (let i = 0; i < pplRes.schema.length; i++) {
          const cur = pplRes.schema[i];
          if (typeof row[i] === 'object') {
            record[cur.name] = JSON.stringify(row[i]);
          } else if (typeof row[i] === 'boolean') {
            record[cur.name] = row[i].toString();
          } else {
            record[cur.name] = row[i];
          }
        }
        data.push(record);
      });
      pplRes.jsonData = data;
    });
    _defineProperty(this, "getDataSource", () => this.pplDataSource);
    if (this.dataType === 'jdbc') {
      this.addSchemaRowMapping();
    } else if (this.dataType === 'viz') {
      this.addStatsMapping();
    }
  }
}
exports.PPLDataSource = PPLDataSource;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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