"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setAsyncSessionId = exports.getAsyncSessionId = void 0;
var _shared = require("../constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const setAsyncSessionId = (dataSource, value) => {
  if (value !== null) {
    sessionStorage.setItem(`${_shared.ASYNC_QUERY_SESSION_ID}_${dataSource}`, value);
  }
};
exports.setAsyncSessionId = setAsyncSessionId;
const getAsyncSessionId = dataSource => {
  return sessionStorage.getItem(`${_shared.ASYNC_QUERY_SESSION_ID}_${dataSource}`);
};
exports.getAsyncSessionId = getAsyncSessionId;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc2hhcmVkIiwicmVxdWlyZSIsInNldEFzeW5jU2Vzc2lvbklkIiwiZGF0YVNvdXJjZSIsInZhbHVlIiwic2Vzc2lvblN0b3JhZ2UiLCJzZXRJdGVtIiwiQVNZTkNfUVVFUllfU0VTU0lPTl9JRCIsImV4cG9ydHMiLCJnZXRBc3luY1Nlc3Npb25JZCIsImdldEl0ZW0iXSwic291cmNlcyI6WyJxdWVyeV9zZXNzaW9uX3V0aWxzLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHsgQVNZTkNfUVVFUllfU0VTU0lPTl9JRCB9IGZyb20gJy4uL2NvbnN0YW50cy9zaGFyZWQnO1xuXG5leHBvcnQgY29uc3Qgc2V0QXN5bmNTZXNzaW9uSWQgPSAoZGF0YVNvdXJjZTogc3RyaW5nLCB2YWx1ZTogc3RyaW5nIHwgbnVsbCkgPT4ge1xuICBpZiAodmFsdWUgIT09IG51bGwpIHtcbiAgICBzZXNzaW9uU3RvcmFnZS5zZXRJdGVtKGAke0FTWU5DX1FVRVJZX1NFU1NJT05fSUR9XyR7ZGF0YVNvdXJjZX1gLCB2YWx1ZSk7XG4gIH1cbn07XG5cbmV4cG9ydCBjb25zdCBnZXRBc3luY1Nlc3Npb25JZCA9IChkYXRhU291cmNlOiBzdHJpbmcpID0+IHtcbiAgcmV0dXJuIHNlc3Npb25TdG9yYWdlLmdldEl0ZW0oYCR7QVNZTkNfUVVFUllfU0VTU0lPTl9JRH1fJHtkYXRhU291cmNlfWApO1xufTtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBS0EsSUFBQUEsT0FBQSxHQUFBQyxPQUFBO0FBTEE7QUFDQTtBQUNBO0FBQ0E7O0FBSU8sTUFBTUMsaUJBQWlCLEdBQUdBLENBQUNDLFVBQWtCLEVBQUVDLEtBQW9CLEtBQUs7RUFDN0UsSUFBSUEsS0FBSyxLQUFLLElBQUksRUFBRTtJQUNsQkMsY0FBYyxDQUFDQyxPQUFPLENBQUUsR0FBRUMsOEJBQXVCLElBQUdKLFVBQVcsRUFBQyxFQUFFQyxLQUFLLENBQUM7RUFDMUU7QUFDRixDQUFDO0FBQUNJLE9BQUEsQ0FBQU4saUJBQUEsR0FBQUEsaUJBQUE7QUFFSyxNQUFNTyxpQkFBaUIsR0FBSU4sVUFBa0IsSUFBSztFQUN2RCxPQUFPRSxjQUFjLENBQUNLLE9BQU8sQ0FBRSxHQUFFSCw4QkFBdUIsSUFBR0osVUFBVyxFQUFDLENBQUM7QUFDMUUsQ0FBQztBQUFDSyxPQUFBLENBQUFDLGlCQUFBLEdBQUFBLGlCQUFBIn0=