"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.profileRouter = void 0;
var _configSchema = require("@osd/config-schema");
var _profile_service = require("../services/profile_service");
var _constants = require("./constants");
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const profileRouter = router => {
  router.get({
    path: `${_constants.DEPLOYED_MODEL_PROFILE_API_ENDPOINT}/{modelId}`,
    validate: {
      params: _configSchema.schema.object({
        modelId: _configSchema.schema.string({
          validate: value => {
            if (!/^[a-zA-Z0-9_-]+$/.test(value)) {
              return 'Invalid model id';
            }
          }
        })
      }),
      query: _configSchema.schema.object({
        data_source_id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    try {
      const payload = await _profile_service.ProfileService.getModel({
        transport: await (0, _utils.getOpenSearchClientTransport)({
          dataSourceId: request.query.data_source_id,
          context
        }),
        modelId: request.params.modelId
      });
      return response.ok({
        body: payload
      });
    } catch (error) {
      return response.badRequest({
        body: error
      });
    }
  });
};
exports.profileRouter = profileRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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