"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationCardParser = void 0;
var _csvParserHelper = require("../utils/csv-parser-helper");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const extractIdsFromCsvString = async csv => {
  const lines = await (0, _csvParserHelper.getJsonFromString)(csv);
  return lines.map(line => line.Id).filter(v => v !== null && v !== undefined);
};
const VisualizationCardParser = exports.VisualizationCardParser = {
  id: 'core_visualization',
  async parserProvider(interaction) {
    var _interaction$addition;
    const visualizationOutputs = (_interaction$addition = interaction.additional_info) === null || _interaction$addition === void 0 ? void 0 : _interaction$addition['VisualizationTool.output'];
    if (!visualizationOutputs) {
      return [];
    }
    const visualizationIds = (await Promise.all(visualizationOutputs.map(output => extractIdsFromCsvString(output)))).flatMap(id => id);
    const visOutputs = [...new Set(visualizationIds)]
    /**
     * Empty id will be filtered
     */.filter(id => id).map(id => ({
      type: 'output',
      content: id,
      contentType: 'visualization',
      fullWidth: true,
      suggestedActions: [{
        message: 'View in Visualize',
        actionType: 'view_in_dashboards'
      }]
    }));
    return visOutputs;
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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