/**
 * chroma.js - JavaScript library for color conversions
 *
 * Copyright (c) 2011-2019, Gregor Aisch
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name Gregor Aisch may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GREGOR AISCH OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -------------------------------------------------------
 *
 * chroma.js includes colors from colorbrewer2.org, which are released under
 * the following license:
 *
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower,
 * and The Pennsylvania State University.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * ------------------------------------------------------
 *
 * Named colors are taken from X11 Color Names.
 * http://www.w3.org/TR/css3-color/#svg-color
 *
 * @preserve
 */

!function(t,r){"object"==typeof exports&&"undefined"!=typeof module?module.exports=r():"function"==typeof define&&define.amd?define(r):(t="undefined"!=typeof globalThis?globalThis:t||self).chroma=r()}(this,(function(){"use strict";for(var t=function(t,r,n){return void 0===r&&(r=0),void 0===n&&(n=1),t<r?r:t>n?n:t},r=t,n={},e=0,o=["Boolean","Number","String","Function","Array","Date","RegExp","Undefined","Null"];e<o.length;e+=1){var a=o[e];n["[object "+a+"]"]=a.toLowerCase()}var i=function(t){return n[Object.prototype.toString.call(t)]||"object"},u=i,s=i,l=(Math.PI,function(t){t._clipped=!1,t._unclipped=t.slice(0);for(var n=0;n<=3;n++)n<3?((t[n]<0||t[n]>255)&&(t._clipped=!0),t[n]=r(t[n],0,255)):3===n&&(t[n]=r(t[n],0,1));return t}),h=i,c=function(t,r){return void 0===r&&(r=null),t.length>=3?Array.prototype.slice.call(t):"object"==u(t[0])&&r?r.split("").filter((function(r){return void 0!==t[0][r]})).map((function(r){return t[0][r]})):t[0]},f=function(t){if(t.length<2)return null;var r=t.length-1;return"string"==s(t[r])?t[r].toLowerCase():null},p={format:{},autodetect:[]},g=f,b=l,v=h,d=p,y=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=this;if("object"===v(t[0])&&t[0].constructor&&t[0].constructor===this.constructor)return t[0];var e=g(t),o=!1;if(!e){o=!0,d.sorted||(d.autodetect=d.autodetect.sort((function(t,r){return r.p-t.p})),d.sorted=!0);for(var a=0,i=d.autodetect;a<i.length;a+=1){var u=i[a];if(e=u.test.apply(u,t))break}}if(!d.format[e])throw new Error("unknown format: "+t);var s=d.format[e].apply(null,o?t:t.slice(0,-1));n._rgb=b(s),3===n._rgb.length&&n._rgb.push(1)};y.prototype.toString=function(){return"function"==v(this.hex)?this.hex():"["+this._rgb.join(",")+"]"};var w=y,m=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(m.Color,[null].concat(t)))};m.Color=w,m.version="2.4.2";var k=m,_=c,M=f,x=function(t){return Math.round(100*t)/100},F=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=_(t,"hsla"),e=M(t)||"lsa";return n[0]=x(n[0]||0),n[1]=x(100*n[1])+"%",n[2]=x(100*n[2])+"%","hsla"===e||n.length>3&&n[3]<1?(n[3]=n.length>3?n[3]:1,e="hsla"):n.length=3,e+"("+n.join(",")+")"},j=c,N=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=(t=j(t,"rgba"))[0],e=t[1],o=t[2];n/=255,e/=255,o/=255;var a,i,u=Math.min(n,e,o),s=Math.max(n,e,o),l=(s+u)/2;return s===u?(a=0,i=Number.NaN):a=l<.5?(s-u)/(s+u):(s-u)/(2-s-u),n==s?i=(e-o)/(s-u):e==s?i=2+(o-n)/(s-u):o==s&&(i=4+(n-e)/(s-u)),(i*=60)<0&&(i+=360),t.length>3&&void 0!==t[3]?[i,a,l,t[3]]:[i,a,l]},$=c,A=f,C=F,E=N,O=Math.round,S=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=$(t,"rgba"),e=A(t)||"rgb";return"hsl"==e.substr(0,3)?C(E(n),e):(n[0]=O(n[0]),n[1]=O(n[1]),n[2]=O(n[2]),("rgba"===e||n.length>3&&n[3]<1)&&(n[3]=n.length>3?n[3]:1,e="rgba"),e+"("+n.slice(0,"rgb"===e?3:4).join(",")+")")},L=c,I=Math.round,X=function(){for(var t,r=[],n=arguments.length;n--;)r[n]=arguments[n];var e,o,a,i=(r=L(r,"hsl"))[0],u=r[1],s=r[2];if(0===u)e=o=a=255*s;else{var l=[0,0,0],h=[0,0,0],c=s<.5?s*(1+u):s+u-s*u,f=2*s-c,p=i/360;l[0]=p+1/3,l[1]=p,l[2]=p-1/3;for(var g=0;g<3;g++)l[g]<0&&(l[g]+=1),l[g]>1&&(l[g]-=1),6*l[g]<1?h[g]=f+6*(c-f)*l[g]:2*l[g]<1?h[g]=c:3*l[g]<2?h[g]=f+(c-f)*(2/3-l[g])*6:h[g]=f;e=(t=[I(255*h[0]),I(255*h[1]),I(255*h[2])])[0],o=t[1],a=t[2]}return r.length>3?[e,o,a,r[3]]:[e,o,a,1]},Y=X,Z=/^rgb\(\s*(-?\d+),\s*(-?\d+)\s*,\s*(-?\d+)\s*\)$/,K=/^rgba\(\s*(-?\d+),\s*(-?\d+)\s*,\s*(-?\d+)\s*,\s*([01]|[01]?\.\d+)\)$/,T=/^rgb\(\s*(-?\d+(?:\.\d+)?)%,\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*\)$/,q=/^rgba\(\s*(-?\d+(?:\.\d+)?)%,\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)$/,B=/^hsl\(\s*(-?\d+(?:\.\d+)?),\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*\)$/,D=/^hsla\(\s*(-?\d+(?:\.\d+)?),\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)$/,P=Math.round,R=function(t){var r;if(r=(t=t.toLowerCase().trim()).match(Z)){for(var n=r.slice(1,4),e=0;e<3;e++)n[e]=+n[e];return n[3]=1,n}if(r=t.match(K)){for(var o=r.slice(1,5),a=0;a<4;a++)o[a]=+o[a];return o}if(r=t.match(T)){for(var i=r.slice(1,4),u=0;u<3;u++)i[u]=P(2.55*i[u]);return i[3]=1,i}if(r=t.match(q)){for(var s=r.slice(1,5),l=0;l<3;l++)s[l]=P(2.55*s[l]);return s[3]=+s[3],s}if(r=t.match(B)){var h=r.slice(1,4);h[1]*=.01,h[2]*=.01;var c=Y(h);return c[3]=1,c}if(r=t.match(D)){var f=r.slice(1,4);f[1]*=.01,f[2]*=.01;var p=Y(f);return p[3]=+r[4],p}};R.test=function(t){return Z.test(t)||K.test(t)||T.test(t)||q.test(t)||B.test(t)||D.test(t)};var U=k,z=w,G=p,H=h,J=S,Q=R;z.prototype.css=function(t){return J(this._rgb,t)},U.css=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(z,[null].concat(t,["css"])))},G.format.css=Q,G.autodetect.push({p:5,test:function(t){for(var r=[],n=arguments.length-1;n-- >0;)r[n]=arguments[n+1];if(!r.length&&"string"===H(t)&&Q.test(t))return"css"}});var V=c,W=f,tt=Math.round,rt=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=V(t,"rgba"),e=n[0],o=n[1],a=n[2],i=n[3],u=W(t)||"auto";void 0===i&&(i=1),"auto"===u&&(u=i<1?"rgba":"rgb");var s=(e=tt(e))<<16|(o=tt(o))<<8|(a=tt(a)),l="000000"+s.toString(16);l=l.substr(l.length-6);var h="0"+tt(255*i).toString(16);switch(h=h.substr(h.length-2),u.toLowerCase()){case"rgba":return"#"+l+h;case"argb":return"#"+h+l;default:return"#"+l}},nt=/^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/,et=/^#?([A-Fa-f0-9]{8}|[A-Fa-f0-9]{4})$/,ot=function(t){if(t.match(nt)){4!==t.length&&7!==t.length||(t=t.substr(1)),3===t.length&&(t=(t=t.split(""))[0]+t[0]+t[1]+t[1]+t[2]+t[2]);var r=parseInt(t,16);return[r>>16,r>>8&255,255&r,1]}if(t.match(et)){5!==t.length&&9!==t.length||(t=t.substr(1)),4===t.length&&(t=(t=t.split(""))[0]+t[0]+t[1]+t[1]+t[2]+t[2]+t[3]+t[3]);var n=parseInt(t,16);return[n>>24&255,n>>16&255,n>>8&255,Math.round((255&n)/255*100)/100]}throw new Error("unknown hex color: "+t)},at=k,it=w,ut=h,st=p,lt=rt;it.prototype.hex=function(t){return lt(this._rgb,t)},at.hex=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(it,[null].concat(t,["hex"])))},st.format.hex=ot,st.autodetect.push({p:4,test:function(t){for(var r=[],n=arguments.length-1;n-- >0;)r[n]=arguments[n+1];if(!r.length&&"string"===ut(t)&&[3,4,5,6,7,8,9].indexOf(t.length)>=0)return"hex"}});var ht=c,ct=h,ft=k,pt=w,gt=p,bt=N;pt.prototype.hsl=function(){return bt(this._rgb)},ft.hsl=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(pt,[null].concat(t,["hsl"])))},gt.format.hsl=X,gt.autodetect.push({p:2,test:function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];if(t=ht(t,"hsl"),"array"===ct(t)&&3===t.length)return"hsl"}});var vt={Kn:18,Xn:.95047,Yn:1,Zn:1.08883,t0:.137931034,t1:.206896552,t2:.12841855,t3:.008856452},dt=vt,yt=c,wt=Math.pow,mt=function(t){return(t/=255)<=.04045?t/12.92:wt((t+.055)/1.055,2.4)},kt=function(t){return t>dt.t3?wt(t,1/3):t/dt.t2+dt.t0},_t=function(t,r,n){return t=mt(t),r=mt(r),n=mt(n),[kt((.4124564*t+.3575761*r+.1804375*n)/dt.Xn),kt((.2126729*t+.7151522*r+.072175*n)/dt.Yn),kt((.0193339*t+.119192*r+.9503041*n)/dt.Zn)]},Mt=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=yt(t,"rgb"),e=n[0],o=n[1],a=n[2],i=_t(e,o,a),u=i[0],s=i[1],l=i[2],h=116*s-16;return[h<0?0:h,500*(u-s),200*(s-l)]},xt=vt,Ft=c,jt=Math.pow,Nt=function(t){return 255*(t<=.00304?12.92*t:1.055*jt(t,1/2.4)-.055)},$t=function(t){return t>xt.t1?t*t*t:xt.t2*(t-xt.t0)},At=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n,e,o,a=(t=Ft(t,"lab"))[0],i=t[1],u=t[2];return e=(a+16)/116,n=isNaN(i)?e:e+i/500,o=isNaN(u)?e:e-u/200,e=xt.Yn*$t(e),n=xt.Xn*$t(n),o=xt.Zn*$t(o),[Nt(3.2404542*n-1.5371385*e-.4985314*o),Nt(-.969266*n+1.8760108*e+.041556*o),Nt(.0556434*n-.2040259*e+1.0572252*o),t.length>3?t[3]:1]},Ct=c,Et=h,Ot=k,St=w,Lt=p,It=Mt;St.prototype.lab=function(){return It(this._rgb)},Ot.lab=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(St,[null].concat(t,["lab"])))},Lt.format.lab=At,Lt.autodetect.push({p:2,test:function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];if(t=Ct(t,"lab"),"array"===Et(t)&&3===t.length)return"lab"}});var Xt=c,Yt=Math.cbrt,Zt=Math.pow,Kt=Math.sign,Tt=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=Xt(t,"rgb"),e=n[0],o=n[1],a=n[2],i=[qt(e/255),qt(o/255),qt(a/255)],u=i[0],s=i[1],l=i[2],h=Yt(.4122214708*u+.5363325363*s+.0514459929*l),c=Yt(.2119034982*u+.6806995451*s+.1073969566*l),f=Yt(.0883024619*u+.2817188376*s+.6299787005*l);return[.2104542553*h+.793617785*c-.0040720468*f,1.9779984951*h-2.428592205*c+.4505937099*f,.0259040371*h+.7827717662*c-.808675766*f]};function qt(t){var r=Math.abs(t);return r<.04045?t/12.92:(Kt(t)||1)*Zt((r+.055)/1.055,2.4)}var Bt=c,Dt=Math.pow,Pt=Math.sign,Rt=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=(t=Bt(t,"lab"))[0],e=t[1],o=t[2],a=Dt(n+.3963377774*e+.2158037573*o,3),i=Dt(n-.1055613458*e-.0638541728*o,3),u=Dt(n-.0894841775*e-1.291485548*o,3);return[255*Ut(4.0767416621*a-3.3077115913*i+.2309699292*u),255*Ut(-1.2684380046*a+2.6097574011*i-.3413193965*u),255*Ut(-.0041960863*a-.7034186147*i+1.707614701*u),t.length>3?t[3]:1]};function Ut(t){var r=Math.abs(t);return r>.0031308?(Pt(t)||1)*(1.055*Dt(r,1/2.4)-.055):12.92*t}var zt=c,Gt=h,Ht=k,Jt=w,Qt=p,Vt=Tt;Jt.prototype.oklab=function(){return Vt(this._rgb)},Ht.oklab=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(Jt,[null].concat(t,["oklab"])))},Qt.format.oklab=Rt,Qt.autodetect.push({p:3,test:function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];if(t=zt(t,"oklab"),"array"===Gt(t)&&3===t.length)return"oklab"}});var Wt=k,tr=w,rr=p,nr=c,er=h,or=Math.round;tr.prototype.rgb=function(t){return void 0===t&&(t=!0),!1===t?this._rgb.slice(0,3):this._rgb.slice(0,3).map(or)},tr.prototype.rgba=function(t){return void 0===t&&(t=!0),this._rgb.slice(0,4).map((function(r,n){return n<3?!1===t?r:or(r):r}))},Wt.rgb=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];return new(Function.prototype.bind.apply(tr,[null].concat(t,["rgb"])))},rr.format.rgb=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];var n=nr(t,"rgba");return void 0===n[3]&&(n[3]=1),n},rr.autodetect.push({p:3,test:function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];if(t=nr(t,"rgba"),"array"===er(t)&&(3===t.length||4===t.length&&"number"==er(t[3])&&t[3]>=0&&t[3]<=1))return"rgb"}});var ar=w,ir=h;ar.prototype.alpha=function(t,r){return void 0===r&&(r=!1),void 0!==t&&"number"===ir(t)?r?(this._rgb[3]=t,this):new ar([this._rgb[0],this._rgb[1],this._rgb[2],t],"rgb"):this._rgb[3]};var ur=w,sr=vt;ur.prototype.darken=function(t){void 0===t&&(t=1);var r=this.lab();return r[0]-=sr.Kn*t,new ur(r,"lab").alpha(this.alpha(),!0)},ur.prototype.brighten=function(t){return void 0===t&&(t=1),this.darken(-t)},ur.prototype.darker=ur.prototype.darken,ur.prototype.brighter=ur.prototype.brighten,w.prototype.get=function(t){var r=t.split("."),n=r[0],e=r[1],o=this[n]();if(e){var a=n.indexOf(e)-("ok"===n.substr(0,2)?2:0);if(a>-1)return o[a];throw new Error("unknown channel "+e+" in mode "+n)}return o};var lr={},hr=w,cr=h,fr=lr,pr=function(t,r,n){void 0===n&&(n=.5);for(var e=[],o=arguments.length-3;o-- >0;)e[o]=arguments[o+3];var a=e[0]||"lrgb";if(fr[a]||e.length||(a=Object.keys(fr)[0]),!fr[a])throw new Error("interpolation mode "+a+" is not defined");return"object"!==cr(t)&&(t=new hr(t)),"object"!==cr(r)&&(r=new hr(r)),fr[a](t,r,n).alpha(t.alpha()+n*(r.alpha()-t.alpha()))},gr=w,br=pr;gr.prototype.mix=gr.prototype.interpolate=function(t,r){void 0===r&&(r=.5);for(var n=[],e=arguments.length-2;e-- >0;)n[e]=arguments[e+2];return br.apply(void 0,[this,t,r].concat(n))};var vr=w,dr=h;vr.prototype.set=function(t,r,n){void 0===n&&(n=!1);var e=t.split("."),o=e[0],a=e[1],i=this[o]();if(a){var u=o.indexOf(a)-("ok"===o.substr(0,2)?2:0);if(u>-1){if("string"==dr(r))switch(r.charAt(0)){case"+":case"-":i[u]+=+r;break;case"*":i[u]*=+r.substr(1);break;case"/":i[u]/=+r.substr(1);break;default:i[u]=+r}else{if("number"!==dr(r))throw new Error("unsupported value for Color.set");i[u]=r}var s=new vr(i,o);return n?(this._rgb=s._rgb,this):s}throw new Error("unknown channel "+a+" in mode "+o)}return i};var yr=w,wr=Math.sqrt,mr=Math.pow;lr.lrgb=function(t,r,n){var e=t._rgb,o=e[0],a=e[1],i=e[2],u=r._rgb,s=u[0],l=u[1],h=u[2];return new yr(wr(mr(o,2)*(1-n)+mr(s,2)*n),wr(mr(a,2)*(1-n)+mr(l,2)*n),wr(mr(i,2)*(1-n)+mr(h,2)*n),"rgb")};var kr=w;lr.oklab=function(t,r,n){var e=t.oklab(),o=r.oklab();return new kr(e[0]+n*(o[0]-e[0]),e[1]+n*(o[1]-e[1]),e[2]+n*(o[2]-e[2]),"oklab")};var _r=w,Mr=k;return Mr.mix=Mr.interpolate=pr,Mr.valid=function(){for(var t=[],r=arguments.length;r--;)t[r]=arguments[r];try{return new(Function.prototype.bind.apply(_r,[null].concat(t))),!0}catch(t){return!1}},Mr}));
