"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWorker = exports.registerWorker = void 0;
const workerStoreMap = {};
exports.registerWorker = (workerId, worker) => {
    if (!workerStoreMap[workerId]) {
        workerStoreMap[workerId] = worker;
        return true;
    }
    return false;
};
exports.getWorker = (workerId) => {
    return workerStoreMap[workerId];
};
//# sourceMappingURL=worker_store.js.map