"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.rawConfigServiceMock = void 0;
const rxjs_1 = require("rxjs");
const createRawConfigServiceMock = ({ rawConfig = {}, rawConfig$ = undefined, } = {}) => {
    const mocked = {
        loadConfig: jest.fn(),
        stop: jest.fn(),
        reloadConfig: jest.fn(),
        getConfig$: jest.fn().mockReturnValue(rawConfig$ || rxjs_1.of(rawConfig)),
    };
    return mocked;
};
exports.rawConfigServiceMock = {
    create: createRawConfigServiceMock,
};
