"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutBody = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiFlyoutBody = function EuiFlyoutBody(_ref) {
  var children = _ref.children,
      className = _ref.className,
      banner = _ref.banner,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "banner"]);
  var classes = (0, _classnames.default)('euiFlyoutBody', className);
  var overflowClasses = (0, _classnames.default)('euiFlyoutBody__overflow', {
    'euiFlyoutBody__overflow--hasBanner': banner
  });
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), /*#__PURE__*/_react.default.createElement("div", {
    tabIndex: 0,
    className: overflowClasses
  }, banner && /*#__PURE__*/_react.default.createElement("div", {
    className: "euiFlyoutBody__banner"
  }, banner), /*#__PURE__*/_react.default.createElement("div", {
    className: "euiFlyoutBody__overflowContent"
  }, children)));
};

exports.EuiFlyoutBody = EuiFlyoutBody;
EuiFlyoutBody.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
         * Use to display a banner at the top of the body. It is suggested to use `EuiCallOut` for it.
         */
  banner: _propTypes.default.node
};