"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiStepNumber", {
  enumerable: true,
  get: function get() {
    return _step_number.EuiStepNumber;
  }
});
exports.OuiStepNumber = exports.STATUS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _accessibility = require("../accessibility");

var _common = require("../common");

var _icon = require("../icon");

var _step_strings = require("./step_strings");

var _loading = require("../loading");

var _step_number = require("../../eui_components/steps/step_number");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var statusToClassNameMap = {
  incomplete: 'ouiStepNumber--incomplete',
  disabled: 'ouiStepNumber--disabled',
  loading: 'ouiStepNumber--loading',
  warning: 'ouiStepNumber--warning',
  danger: 'ouiStepNumber--danger',
  complete: 'ouiStepNumber--complete'
};
var STATUS = (0, _common.keysOf)(statusToClassNameMap);
exports.STATUS = STATUS;

var OuiStepNumber = function OuiStepNumber(_ref) {
  var className = _ref.className,
      status = _ref.status,
      number = _ref.number,
      isHollow = _ref.isHollow,
      titleSize = _ref.titleSize,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "status", "number", "isHollow", "titleSize"]);
  var stepAriaLabel = (0, _step_strings.useI18nStep)({
    number: number
  });
  var completeAriaLabel = (0, _step_strings.useI18nCompleteStep)({
    number: number
  });
  var warningAriaLabel = (0, _step_strings.useI18nWarningStep)({
    number: number
  });
  var errorsAriaLabel = (0, _step_strings.useI18nErrorsStep)({
    number: number
  });
  var incompleteAriaLabel = (0, _step_strings.useI18nIncompleteStep)({
    number: number
  });
  var disabledAriaLabel = (0, _step_strings.useI18nDisabledStep)({
    number: number
  });
  var loadingAriaLabel = (0, _step_strings.useI18nLoadingStep)({
    number: number
  });
  var classes = (0, _classnames.default)('ouiStepNumber', status ? statusToClassNameMap[status] : undefined, {
    'ouiStepNumber-isHollow': isHollow
  }, className);
  var iconSize = titleSize === 'xs' ? 's' : 'm';
  var screenReaderText = stepAriaLabel;
  if (status === 'incomplete') screenReaderText = incompleteAriaLabel;else if (status === 'disabled') screenReaderText = disabledAriaLabel;else if (status === 'loading') screenReaderText = loadingAriaLabel;

  var numberOrIcon = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_accessibility.OuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, screenReaderText)), /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiStepNumber__number",
    "aria-hidden": "true"
  }, number));

  if (status === 'complete') {
    numberOrIcon = /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
      type: "check",
      className: "ouiStepNumber__icon",
      size: iconSize,
      "aria-label": completeAriaLabel
    });
  } else if (status === 'warning') {
    numberOrIcon = /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
      type: "alert",
      className: "ouiStepNumber__icon",
      size: iconSize,
      "aria-label": warningAriaLabel
    });
  } else if (status === 'danger') {
    numberOrIcon = /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
      type: "cross",
      className: "ouiStepNumber__icon",
      size: iconSize,
      "aria-label": errorsAriaLabel
    });
  } else if (status === 'loading') {
    numberOrIcon = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_accessibility.OuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, screenReaderText)), /*#__PURE__*/_react.default.createElement(_loading.OuiLoadingSpinner, {
      className: "ouiStepNumber__loader",
      size: iconSize === 's' ? 'l' : 'xl'
    }));
  }

  return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({
    className: classes
  }, rest), numberOrIcon);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiStepNumber = OuiStepNumber;
OuiStepNumber.propTypes = {
  /**
     * May replace the number provided in props.number with alternate styling
     */
  status: _propTypes.default.any,
  number: _propTypes.default.number,

  /**
     * Uses a border and removes the step number.
     */
  isHollow: _propTypes.default.bool,

  /**
     * Title sizing equivalent to OuiTitle, but only `m`, `s` and `xs`. Defaults to `s`
     */
  titleSize: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
/* OUI -> EUI Aliases: Build-Time */