"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeprecatedPropWarning = exports.deprecatedComponentWarning = exports.getDeprecatedMessage = void 0;

var _react = _interopRequireWildcard(require("react"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright OpenSearch Contributors
                                                                       * SPDX-License-Identifier: Apache-2.0
                                                                       */

var getDeprecatedMessage = function getDeprecatedMessage(message) {
  return "[DEPRECATED] ".concat(message);
};

exports.getDeprecatedMessage = getDeprecatedMessage;

var deprecatedComponentWarning = function deprecatedComponentWarning(_ref) {
  var newComponentName = _ref.newComponentName,
      version = _ref.version,
      getMessage = _ref.getMessage;
  return function (Component) {
    var deprecatedComponentName = Component.displayName || Component.name;

    var DeprecatedWrapper = function DeprecatedWrapper(props) {
      (0, _react.useEffect)(function () {
        var defaultMessage = version ? "".concat(deprecatedComponentName, " is deprecated in favor of ").concat(newComponentName, " and will be removed in v").concat(version, ".") : "".concat(deprecatedComponentName, " is deprecated in favor of ").concat(newComponentName, " and will be removed.");
        var message = (getMessage === null || getMessage === void 0 ? void 0 : getMessage(deprecatedComponentName)) || defaultMessage;
        var deprecatedMessage = getDeprecatedMessage(message);
        console.warn(deprecatedMessage);
      }, []);
      return /*#__PURE__*/_react.default.createElement(Component, props);
    };

    Object.defineProperty(DeprecatedWrapper, 'name', {
      value: deprecatedComponentName
    });
    return DeprecatedWrapper;
  };
};

exports.deprecatedComponentWarning = deprecatedComponentWarning;

var useDeprecatedPropWarning = function useDeprecatedPropWarning(_ref2) {
  var props = _ref2.props,
      version = _ref2.version,
      getMessage = _ref2.getMessage;
  var warnedProps = (0, _react.useRef)(new Set()).current;
  (0, _react.useEffect)(function () {
    Object.entries(props).forEach(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
          name = _ref4[0],
          value = _ref4[1];

      if (value !== undefined && !warnedProps.has(name)) {
        var defaultMessage = version ? "The `".concat(name, "` prop is deprecated and will be removed in v").concat(version, ".") : "The `".concat(name, "` prop is deprecated and will be removed.");
        var message = (getMessage === null || getMessage === void 0 ? void 0 : getMessage(name)) || defaultMessage;
        var deprecatedMessage = getDeprecatedMessage(message);
        warnedProps.add(name);
        console.warn(deprecatedMessage);
      }
    });
  }, [warnedProps, props, version, getMessage]);
};

exports.useDeprecatedPropWarning = useDeprecatedPropWarning;