// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { _encryptStream } from './encrypt_stream';
// @ts-ignore
import { finished } from 'readable-stream';
export async function _encrypt(clientOptions, cmm, plaintext, op = {}) {
    const { encoding } = op;
    if (plaintext instanceof Uint8Array) {
        op.plaintextLength = plaintext.byteLength;
    }
    else if (typeof plaintext === 'string') {
        plaintext = Buffer.from(plaintext, encoding);
        op.plaintextLength = plaintext.byteLength;
    }
    const stream = _encryptStream(clientOptions, cmm, op);
    const result = [];
    let messageHeader = false;
    stream
        .once('MessageHeader', (header) => {
        messageHeader = header;
    })
        .on('data', (chunk) => result.push(chunk));
    // This will check both Uint8Array|Buffer
    if (plaintext instanceof Uint8Array) {
        stream.end(plaintext);
    }
    else if (plaintext.readable) {
        plaintext.pipe(stream);
    }
    else {
        throw new Error('Unsupported plaintext');
    }
    await finishedAsync(stream);
    if (!messageHeader)
        throw new Error('Unknown format');
    return {
        result: Buffer.concat(result),
        messageHeader,
    };
}
async function finishedAsync(stream) {
    return new Promise((resolve, reject) => {
        finished(stream, (err) => (err ? reject(err) : resolve()));
    });
}
//# sourceMappingURL=data:application/json;base64,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