/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class CompressOutputStream
extends OutputStream {
    private static final int MIN_COMPRESSION_SIZE = 16384;
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private static final float MIN_COMPRESSION_RATIO = 0.9f;
    OutputStream baseStream;
    byte[] header = new byte[7];
    int seqNo = 0;

    public CompressOutputStream(OutputStream baseStream) {
        this.baseStream = baseStream;
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        if (len > 0xFFFFFF) {
            int bytesToWrite;
            do {
                bytesToWrite = Math.min(len, 0xFFFFFF);
                this.write(bytes, off, bytesToWrite);
                off += bytesToWrite;
            } while ((len -= bytesToWrite) != 0);
            return;
        }
        int compressedLength = len;
        int uncompressedLength = 0;
        if (bytes.length > 16384) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DeflaterOutputStream deflater = new DeflaterOutputStream(baos);
            deflater.write(bytes, off, len);
            deflater.finish();
            deflater.close();
            byte[] compressedBytes = baos.toByteArray();
            baos.close();
            if (compressedBytes.length < (int)(0.9f * (float)len)) {
                compressedLength = compressedBytes.length;
                uncompressedLength = len;
                bytes = compressedBytes;
                off = 0;
            }
        }
        this.header[0] = (byte)(compressedLength & 0xFF);
        this.header[1] = (byte)(compressedLength >> 8 & 0xFF);
        this.header[2] = (byte)(compressedLength >> 16 & 0xFF);
        this.header[3] = (byte)this.seqNo++;
        this.header[4] = (byte)(uncompressedLength & 0xFF);
        this.header[5] = (byte)(uncompressedLength >> 8 & 0xFF);
        this.header[6] = (byte)(uncompressedLength >> 16 & 0xFF);
        this.baseStream.write(this.header);
        this.baseStream.write(bytes, off, compressedLength);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (bytes.length < 3) {
            throw new AssertionError((Object)"Invalid call, at least 3 byte writes are required");
        }
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(int bytes) throws IOException {
        throw new AssertionError((Object)"Invalid call, at least 3 byte writes are required");
    }

    @Override
    public void flush() throws IOException {
        this.baseStream.flush();
        this.seqNo = 0;
    }
}

