/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.mariadb.jdbc.internal.util.constant.HaMode;

public class HostAddress {
    public String host;
    public int port;
    public String type = null;

    public HostAddress() {
    }

    public HostAddress(String host, int port) {
        this.host = host;
        this.port = port;
        this.type = "master";
    }

    public HostAddress(String host, int port, String type) {
        this.host = host;
        this.port = port;
        this.type = type;
    }

    public static List<HostAddress> parse(String spec, HaMode haMode) {
        if (spec == null) {
            throw new IllegalArgumentException("Invalid connection URL, host address must not be empty ");
        }
        if ("".equals(spec)) {
            return new ArrayList<HostAddress>(0);
        }
        String[] tokens = spec.trim().split(",");
        ArrayList<HostAddress> arr = new ArrayList<HostAddress>(tokens.length);
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            if (tokens[i2].startsWith("address=")) {
                arr.add(HostAddress.parseParameterHostAddress(tokens[i2]));
                continue;
            }
            arr.add(HostAddress.parseSimpleHostAddress(tokens[i2]));
        }
        int defaultPort = ((HostAddress)arr.get((int)(arr.size() - 1))).port;
        if (defaultPort == 0) {
            defaultPort = 3306;
        }
        for (int i3 = 0; i3 < arr.size(); ++i3) {
            if (haMode == HaMode.REPLICATION) {
                if (i3 == 0 && ((HostAddress)arr.get((int)i3)).type == null) {
                    ((HostAddress)arr.get((int)i3)).type = "master";
                } else if (i3 != 0 && ((HostAddress)arr.get((int)i3)).type == null) {
                    ((HostAddress)arr.get((int)i3)).type = "slave";
                }
            }
            if (((HostAddress)arr.get((int)i3)).port != 0) continue;
            ((HostAddress)arr.get((int)i3)).port = defaultPort;
        }
        return arr;
    }

    static HostAddress parseSimpleHostAddress(String str) {
        HostAddress result = new HostAddress();
        if (str.charAt(0) == '[') {
            int ind = str.indexOf(93);
            result.host = str.substring(1, ind);
            if (ind != str.length() - 1 && str.charAt(ind + 1) == ':') {
                result.port = Integer.parseInt(str.substring(ind + 2));
            }
        } else if (str.contains(":")) {
            String[] hostPort = str.split(":");
            result.host = hostPort[0];
            result.port = Integer.parseInt(hostPort[1]);
        } else {
            result.host = str;
        }
        return result;
    }

    static HostAddress parseParameterHostAddress(String str) {
        HostAddress result = new HostAddress();
        String[] array = str.split("(?=\\()|(?<=\\))");
        for (int i2 = 1; i2 < array.length; ++i2) {
            String[] token = array[i2].replace("(", "").replace(")", "").trim().split("=");
            if (token.length != 2) {
                throw new IllegalArgumentException("Invalid connection URL, expected key=value pairs, found " + array[i2]);
            }
            String key = token[0].toLowerCase();
            String value = token[1].toLowerCase();
            if (key.equals("host")) {
                result.host = value.replace("[", "").replace("]", "");
                continue;
            }
            if (key.equals("port")) {
                result.port = Integer.parseInt(value);
                continue;
            }
            if (!key.equals("type") || !value.equals("master") && !value.equals("slave")) continue;
            result.type = value;
        }
        return result;
    }

    public static String toString(List<HostAddress> addrs) {
        String str = "";
        for (int i2 = 0; i2 < addrs.size(); ++i2) {
            if (addrs.get((int)i2).type != null) {
                str = str + "address=(host=" + addrs.get((int)i2).host + ")(port=" + addrs.get((int)i2).port + ")(type=" + addrs.get((int)i2).type + ")";
            } else {
                boolean isIPv6 = addrs.get((int)i2).host != null && addrs.get((int)i2).host.contains(":");
                String host = isIPv6 ? "[" + addrs.get((int)i2).host + "]" : addrs.get((int)i2).host;
                str = str + host + ":" + addrs.get((int)i2).port;
            }
            if (i2 >= addrs.size() - 1) continue;
            str = str + ",";
        }
        return str;
    }

    public static String toString(HostAddress[] addrs) {
        String str = "";
        for (int i2 = 0; i2 < addrs.length; ++i2) {
            if (addrs[i2].type != null) {
                str = str + "address=(host=" + addrs[i2].host + ")(port=" + addrs[i2].port + ")(type=" + addrs[i2].type + ")";
            } else {
                boolean isIPv6 = addrs[i2].host != null && addrs[i2].host.contains(":");
                String host = isIPv6 ? "[" + addrs[i2].host + "]" : addrs[i2].host;
                str = str + host + ":" + addrs[i2].port;
            }
            if (i2 >= addrs.length - 1) continue;
            str = str + ",";
        }
        return str;
    }

    public String toString() {
        return "HostAddress{host='" + this.host + '\'' + ", port=" + this.port + ", type='" + this.type + '\'' + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostAddress that = (HostAddress)obj;
        if (this.port != that.port) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return !(this.type == null ? that.type != null : !this.type.equals(that.type));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }
}

