/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.ClusterDescription;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.ServerDescription;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaggableReadPreference
extends ReadPreference {
    final List<TagSet> tagSetList;

    TaggableReadPreference() {
        this.tagSetList = Collections.emptyList();
    }

    TaggableReadPreference(List<TagSet> tagSetList) {
        this.tagSetList = Collections.unmodifiableList(new ArrayList<TagSet>(tagSetList));
    }

    @Override
    public boolean isSlaveOk() {
        return true;
    }

    @Override
    @Deprecated
    public DBObject toDBObject() {
        BasicDBObject readPrefObject = new BasicDBObject("mode", this.getName());
        if (!this.tagSetList.isEmpty()) {
            ArrayList<BasicDBObject> tagSetDocumentList = new ArrayList<BasicDBObject>();
            for (TagSet tagSet : this.tagSetList) {
                BasicDBObject tagSetDocument = new BasicDBObject();
                for (Tag tag : tagSet) {
                    tagSetDocument.put(tag.getName(), (Object)tag.getValue());
                }
                tagSetDocumentList.add(tagSetDocument);
            }
            readPrefObject.put("tags", (Object)tagSetDocumentList);
        }
        return readPrefObject;
    }

    public List<TagSet> getTagSetList() {
        return this.tagSetList;
    }

    @Deprecated
    public List<DBObject> getTagSets() {
        ArrayList<DBObject> tags = new ArrayList<DBObject>();
        for (TagSet curTags : this.tagSetList) {
            BasicDBObject tagsDocument = new BasicDBObject();
            for (Tag curTag : curTags) {
                tagsDocument.put(curTag.getName(), (Object)curTag.getValue());
            }
            tags.add(tagsDocument);
        }
        return tags;
    }

    public String toString() {
        return this.getName() + this.printTags();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggableReadPreference that = (TaggableReadPreference)o;
        return this.tagSetList.equals(that.tagSetList);
    }

    public int hashCode() {
        int result = this.tagSetList.hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    @Override
    List<ServerDescription> choose(ClusterDescription clusterDescription) {
        if (this.tagSetList.isEmpty()) {
            return this.getServers(clusterDescription);
        }
        for (TagSet tags : this.tagSetList) {
            List<ServerDescription> taggedServers = this.getServersForTags(clusterDescription, tags);
            if (taggedServers.isEmpty()) continue;
            return taggedServers;
        }
        return Collections.emptyList();
    }

    abstract List<ServerDescription> getServers(ClusterDescription var1);

    abstract List<ServerDescription> getServersForTags(ClusterDescription var1, TagSet var2);

    String printTags() {
        return this.tagSetList.isEmpty() ? "" : " : " + this.tagSetList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrimaryPreferredReadPreference
    extends SecondaryReadPreference {
        PrimaryPreferredReadPreference() {
        }

        PrimaryPreferredReadPreference(List<TagSet> tagsList) {
            super(tagsList);
        }

        @Override
        public String getName() {
            return "primaryPreferred";
        }

        @Override
        List<ServerDescription> choose(ClusterDescription clusterDescription) {
            List<ServerDescription> servers = clusterDescription.getPrimaries();
            return !servers.isEmpty() ? servers : super.choose(clusterDescription);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NearestReadPreference
    extends TaggableReadPreference {
        NearestReadPreference() {
        }

        NearestReadPreference(List<TagSet> tagsList) {
            super(tagsList);
        }

        @Override
        public String getName() {
            return "nearest";
        }

        @Override
        List<ServerDescription> getServers(ClusterDescription clusterDescription) {
            return clusterDescription.getAnyPrimaryOrSecondary();
        }

        @Override
        List<ServerDescription> getServersForTags(ClusterDescription clusterDescription, TagSet tags) {
            return clusterDescription.getAnyPrimaryOrSecondary(tags);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SecondaryPreferredReadPreference
    extends SecondaryReadPreference {
        SecondaryPreferredReadPreference() {
        }

        SecondaryPreferredReadPreference(List<TagSet> tagsList) {
            super(tagsList);
        }

        @Override
        public String getName() {
            return "secondaryPreferred";
        }

        @Override
        List<ServerDescription> choose(ClusterDescription clusterDescription) {
            List<ServerDescription> servers = super.choose(clusterDescription);
            return !servers.isEmpty() ? servers : clusterDescription.getPrimaries();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SecondaryReadPreference
    extends TaggableReadPreference {
        SecondaryReadPreference() {
        }

        SecondaryReadPreference(List<TagSet> tagsList) {
            super(tagsList);
        }

        @Override
        public String getName() {
            return "secondary";
        }

        @Override
        List<ServerDescription> getServers(ClusterDescription clusterDescription) {
            return clusterDescription.getSecondaries();
        }

        @Override
        List<ServerDescription> getServersForTags(ClusterDescription clusterDescription, TagSet tags) {
            return clusterDescription.getSecondaries(tags);
        }
    }
}

