/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.util;

import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.util.CheckedSupplier;

public class ExponentialBackoff {
    private final long maxRetry;
    private static final int[] BACKOFF_SCHEDULE_MS = new int[]{100, 200, 400, 800, 1600, 3200, 6400, 12800, 25600, 51200};
    private static final int BACKOFF_MAX_MS = 60000;
    private static final Logger logger = LogManager.getLogger(ExponentialBackoff.class);

    public ExponentialBackoff(long maxRetry) {
        this.maxRetry = maxRetry;
    }

    public <T> T retryable(CheckedSupplier<T> action) throws RetryException {
        long attempt = 0L;
        while (true) {
            try {
                ++attempt;
                return action.get();
            }
            catch (Exception ex) {
                logger.error("Backoff retry exception", (Throwable)ex);
                if (!this.hasRetry(attempt)) continue;
                try {
                    int ms = this.backoffTime(attempt);
                    logger.info("Retry({}) will execute in {} second", (Object)attempt, (Object)((double)ms / 1000.0));
                    Thread.sleep(ms);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RetryException("Backoff retry aborted", e);
                }
                if (this.hasRetry(attempt)) continue;
                throw new RetryException("Reach max retry");
            }
            break;
        }
    }

    private int backoffTime(Long attempt) {
        return attempt - 1L < (long)BACKOFF_SCHEDULE_MS.length ? BACKOFF_SCHEDULE_MS[attempt.intValue() - 1] + new Random().nextInt(1000) : 60000;
    }

    private boolean hasRetry(long attempt) {
        return attempt <= this.maxRetry;
    }

    public static class RetryException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RetryException(String message) {
            super(message);
        }

        public RetryException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

