/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.instrument.metrics.AbstractMetric;
import org.logstash.instrument.metrics.FlowMetric;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.MetricType;
import org.logstash.util.SetOnceReference;

public class LazyInstantiatedFlowMetric
extends AbstractMetric<Map<String, Double>>
implements FlowMetric {
    static final Logger LOGGER = LogManager.getLogger(LazyInstantiatedFlowMetric.class);
    private final AtomicReference<Supplier<? extends Metric<? extends Number>>> numeratorSupplier;
    private final AtomicReference<Supplier<? extends Metric<? extends Number>>> denominatorSupplier;
    private final SetOnceReference<FlowMetric> inner = SetOnceReference.unset();
    private static final Map<String, Double> EMPTY_MAP = Map.of();

    LazyInstantiatedFlowMetric(String name, Supplier<? extends Metric<? extends Number>> numeratorSupplier, Supplier<? extends Metric<? extends Number>> denominatorSupplier) {
        super(name);
        this.numeratorSupplier = new AtomicReference<Supplier<? extends Metric<? extends Number>>>(numeratorSupplier);
        this.denominatorSupplier = new AtomicReference<Supplier<? extends Metric<? extends Number>>>(denominatorSupplier);
    }

    @Override
    public void capture() {
        this.getInner().ifPresentOrElse(FlowMetric::capture, this::warnNotInitialized);
    }

    @Override
    public MetricType getType() {
        return MetricType.FLOW_RATE;
    }

    @Override
    public Map<String, Double> getValue() {
        return this.getInner().map(Metric::getValue).orElse(EMPTY_MAP);
    }

    private Optional<FlowMetric> getInner() {
        return this.inner.asOptional().or(this::attemptCreateInner);
    }

    private Optional<FlowMetric> attemptCreateInner() {
        if (this.inner.isSet()) {
            return this.inner.asOptional();
        }
        Metric<? extends Number> numeratorMetric = this.numeratorSupplier.getAcquire().get();
        if (Objects.isNull(numeratorMetric)) {
            return Optional.empty();
        }
        Metric<? extends Number> denominatorMetric = this.denominatorSupplier.getAcquire().get();
        if (Objects.isNull(denominatorMetric)) {
            return Optional.empty();
        }
        FlowMetric flowMetric = FlowMetric.create(this.name, numeratorMetric, denominatorMetric);
        if (this.inner.offer(flowMetric)) {
            LOGGER.debug("Inner FlowMetric lazy-initialized for {}", (Object)this.name);
            this.numeratorSupplier.setRelease(LazyInstantiatedFlowMetric.constantMetricSupplierFor(numeratorMetric));
            this.denominatorSupplier.setRelease(LazyInstantiatedFlowMetric.constantMetricSupplierFor(denominatorMetric));
            return Optional.of(flowMetric);
        }
        return this.inner.asOptional();
    }

    private void warnNotInitialized() {
        LOGGER.warn("Underlying metrics for `{}` not yet instantiated, could not capture their rates", (Object)this.name);
    }

    private static Supplier<Metric<? extends Number>> constantMetricSupplierFor(Metric<? extends Number> mm) {
        return () -> mm;
    }
}

