/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.counter.LongCounter;
import org.logstash.instrument.metrics.timer.TimerMetric;

@JRubyClass(name={"AbstractFilterDelegator"})
public abstract class AbstractFilterDelegatorExt
extends RubyObject {
    private static final long serialVersionUID = 1L;
    protected AbstractNamespacedMetricExt metricEvents;
    protected RubyString id;
    protected transient LongCounter eventMetricOut;
    protected transient LongCounter eventMetricIn;
    protected transient TimerMetric eventMetricTime;

    public AbstractFilterDelegatorExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMetrics(String id, AbstractNamespacedMetricExt namespacedMetric) {
        ThreadContext context = RubyUtil.RUBY.getCurrentContext();
        this.id = RubyString.newString((Ruby)context.runtime, (String)id);
        AbstractMetricExt abstractMetricExt = namespacedMetric.getMetric();
        synchronized (abstractMetricExt) {
            this.metricEvents = namespacedMetric.namespace(context, (IRubyObject)MetricKeys.EVENTS_KEY);
            this.eventMetricOut = LongCounter.fromRubyBase(this.metricEvents, MetricKeys.OUT_KEY);
            this.eventMetricIn = LongCounter.fromRubyBase(this.metricEvents, MetricKeys.IN_KEY);
            this.eventMetricTime = TimerMetric.fromRubyBase(this.metricEvents, MetricKeys.DURATION_IN_MILLIS_KEY);
            namespacedMetric.gauge(context, (IRubyObject)MetricKeys.NAME_KEY, this.configName(context));
        }
    }

    @JRubyMethod
    public IRubyObject register(ThreadContext context) {
        this.doRegister(context);
        return context.nil;
    }

    protected abstract void doRegister(ThreadContext var1);

    @JRubyMethod
    public IRubyObject close(ThreadContext context) {
        return this.closeImpl(context);
    }

    protected abstract IRubyObject closeImpl(ThreadContext var1);

    @JRubyMethod(name={"do_close"})
    public IRubyObject doClose(ThreadContext context) {
        return this.doCloseImpl(context);
    }

    protected abstract IRubyObject doCloseImpl(ThreadContext var1);

    @JRubyMethod(name={"do_stop"})
    public IRubyObject doStop(ThreadContext context) {
        return this.doStopImpl(context);
    }

    protected abstract IRubyObject doStopImpl(ThreadContext var1);

    @JRubyMethod(name={"reloadable?"})
    public IRubyObject isReloadable(ThreadContext context) {
        return this.reloadable(context);
    }

    protected abstract IRubyObject reloadable(ThreadContext var1);

    @JRubyMethod(name={"threadsafe?"})
    public IRubyObject threadsafe(ThreadContext context) {
        return this.isThreadsafe(context);
    }

    protected abstract IRubyObject isThreadsafe(ThreadContext var1);

    @JRubyMethod(name={"config_name"})
    public IRubyObject configName(ThreadContext context) {
        return this.getConfigName(context);
    }

    protected abstract IRubyObject getConfigName(ThreadContext var1);

    @JRubyMethod(name={"id"})
    public IRubyObject getId() {
        return this.id;
    }

    @JRubyMethod(name={"multi_filter"})
    public RubyArray multiFilter(IRubyObject input) {
        RubyArray batch = (RubyArray)input;
        this.eventMetricIn.increment(batch.size());
        RubyArray result = this.eventMetricTime.time(() -> this.doMultiFilter(batch));
        int count = 0;
        for (JrubyEventExtLibrary.RubyEvent event : result) {
            if (event.getEvent().isCancelled()) continue;
            ++count;
        }
        this.eventMetricOut.increment(count);
        return result;
    }

    protected abstract RubyArray doMultiFilter(RubyArray var1);

    @JRubyMethod(name={"flush"})
    public RubyArray flush(IRubyObject input) {
        RubyArray result;
        RubyHash options = (RubyHash)input;
        ThreadContext context = RubyUtil.RUBY.getCurrentContext();
        IRubyObject newEvents = this.doFlush(context, options);
        if (newEvents.isNil()) {
            result = RubyArray.newEmptyArray((Ruby)context.runtime);
        } else {
            result = (RubyArray)newEvents;
            this.eventMetricOut.increment(result.size());
        }
        return result;
    }

    @JRubyMethod(name={"has_flush"})
    public IRubyObject hasFlush(ThreadContext context) {
        return this.hasFlush() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"periodic_flush"})
    public IRubyObject hasPeriodicFlush(ThreadContext context) {
        return this.periodicFlush() ? context.tru : context.fals;
    }

    protected abstract IRubyObject doFlush(ThreadContext var1, RubyHash var2);

    public boolean hasFlush() {
        return this.getHasFlush();
    }

    protected abstract boolean getHasFlush();

    public boolean periodicFlush() {
        return this.getPeriodicFlush();
    }

    protected abstract boolean getPeriodicFlush();
}

