/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.ext.JRubyAckedQueueExt;
import org.logstash.execution.AbstractWrappedQueueExt;
import org.logstash.execution.QueueReadClientBase;
import org.logstash.ext.JRubyAbstractQueueWriteClientExt;
import org.logstash.ext.JrubyAckedReadClientExt;
import org.logstash.ext.JrubyAckedWriteClientExt;
import org.logstash.ext.JrubyEventExtLibrary;

@JRubyClass(name={"WrappedAckedQueue"})
public final class JRubyWrappedAckedQueueExt
extends AbstractWrappedQueueExt {
    private static final long serialVersionUID = 1L;
    private JRubyAckedQueueExt queue;

    @JRubyMethod(optional=8)
    public JRubyWrappedAckedQueueExt initialize(ThreadContext context, IRubyObject[] args) throws IOException {
        args = Arity.scanArgs((Ruby)context.runtime, (IRubyObject[])args, (int)8, (int)0);
        int capacity = RubyFixnum.num2int((IRubyObject)args[1]);
        int maxEvents = RubyFixnum.num2int((IRubyObject)args[2]);
        int checkpointMaxWrites = RubyFixnum.num2int((IRubyObject)args[3]);
        int checkpointMaxAcks = RubyFixnum.num2int((IRubyObject)args[4]);
        boolean checkpointRetry = !((RubyBoolean)args[6]).isFalse();
        long queueMaxBytes = RubyFixnum.num2long((IRubyObject)args[7]);
        this.queue = JRubyAckedQueueExt.create(args[0].asJavaString(), capacity, maxEvents, checkpointMaxWrites, checkpointMaxAcks, checkpointRetry, queueMaxBytes);
        this.queue.open();
        return this;
    }

    public JRubyWrappedAckedQueueExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(name={"queue"})
    public JRubyAckedQueueExt rubyGetQueue() {
        return this.queue;
    }

    public void close() throws IOException {
        this.queue.close();
    }

    @JRubyMethod(name={"push", "<<"})
    public void rubyPush(ThreadContext context, IRubyObject event) {
        this.queue.rubyWrite(context, ((JrubyEventExtLibrary.RubyEvent)event).getEvent());
    }

    @JRubyMethod(name={"read_batch"})
    public IRubyObject rubyReadBatch(ThreadContext context, IRubyObject size, IRubyObject wait) {
        return this.queue.rubyReadBatch(context, size, wait);
    }

    @JRubyMethod(name={"is_empty?"})
    public IRubyObject rubyIsEmpty(ThreadContext context) {
        return RubyBoolean.newBoolean((Ruby)context.runtime, (boolean)this.queue.isEmpty());
    }

    @Override
    protected JRubyAbstractQueueWriteClientExt getWriteClient(ThreadContext context) {
        return JrubyAckedWriteClientExt.create(this.queue);
    }

    @Override
    protected QueueReadClientBase getReadClient() {
        return JrubyAckedReadClientExt.create((IRubyObject)this.queue);
    }

    @Override
    protected IRubyObject doClose(ThreadContext context) {
        try {
            this.close();
        }
        catch (IOException e) {
            throw RubyUtil.newRubyIOError(context.runtime, e);
        }
        return context.nil;
    }
}

