/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.parser.UnicodeReader;
import com.sun.tools.javac.util.Context;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;

final class JavacTokens {
    private static final CharSequence EOF_COMMENT = "\n//EOF";
    private static final Tokens.TokenKind STRINGFRAGMENT = Arrays.stream(Tokens.TokenKind.values()).filter(t -> t.name().contentEquals("STRINGFRAGMENT")).findFirst().orElse(null);

    static boolean isStringFragment(Tokens.TokenKind kind) {
        return STRINGFRAGMENT != null && Objects.equals(kind, STRINGFRAGMENT);
    }

    private static ImmutableList<Tokens.Token> readAllTokens(String source, Context context, Set<Integer> nonTerminalStringFragments) {
        if (source == null) {
            return ImmutableList.of();
        }
        ScannerFactory fac = ScannerFactory.instance(context);
        char[] buffer = (source + String.valueOf(EOF_COMMENT)).toCharArray();
        AccessibleScanner scanner = new AccessibleScanner(fac, new CommentSavingTokenizer(fac, buffer, buffer.length));
        ArrayList<Tokens.Token> tokens = new ArrayList<Tokens.Token>();
        do {
            scanner.nextToken();
            tokens.add(scanner.token());
        } while (scanner.token().kind != Tokens.TokenKind.EOF);
        for (int i = 0; i < tokens.size(); ++i) {
            if (!JavacTokens.isStringFragment(((Tokens.Token)tokens.get((int)i)).kind)) continue;
            int start = i;
            while (JavacTokens.isStringFragment(((Tokens.Token)tokens.get((int)i)).kind)) {
                ++i;
            }
            for (int j = start; j < i - 1; ++j) {
                nonTerminalStringFragments.add(((Tokens.Token)tokens.get((int)j)).pos);
            }
        }
        if (Runtime.version().feature() >= 21) {
            Collections.sort(tokens, Comparator.comparingInt(t -> t.pos));
        }
        return ImmutableList.copyOf(tokens);
    }

    public static ImmutableList<RawTok> getTokens(String source, Context context, Set<Tokens.TokenKind> stopTokens) {
        if (source == null) {
            return ImmutableList.of();
        }
        HashSet<Integer> nonTerminalStringFragments = new HashSet<Integer>();
        ImmutableList<Tokens.Token> javacTokens = JavacTokens.readAllTokens(source, context, nonTerminalStringFragments);
        ImmutableList.Builder tokens = ImmutableList.builder();
        int end = source.length();
        int last = 0;
        for (Tokens.Token t : javacTokens) {
            if (t.comments != null) {
                for (Tokens.Comment c : Lists.reverse(t.comments)) {
                    int length;
                    int pos = c.getSourcePos(0);
                    if (pos == -1) {
                        pos = source.indexOf(47, last);
                        length = CommentSavingTokenizer.commentLength(c);
                    } else {
                        length = c.getText().length();
                    }
                    if (last < pos) {
                        tokens.add((Object)new RawTok(null, null, last, pos));
                    }
                    tokens.add((Object)new RawTok(null, null, pos, pos + length));
                    last = pos + length;
                }
            }
            if (stopTokens.contains(t.kind)) {
                if (t.kind == Tokens.TokenKind.EOF) break;
                end = t.pos;
                break;
            }
            if (last < t.pos) {
                tokens.add((Object)new RawTok(null, null, last, t.pos));
            }
            if (JavacTokens.isStringFragment(t.kind)) {
                int endPos = t.endPos;
                int pos = t.pos;
                if (nonTerminalStringFragments.contains(t.pos)) {
                    ++endPos;
                }
                tokens.add((Object)new RawTok(source.substring(pos, endPos), t.kind, pos, endPos));
                last = endPos;
                continue;
            }
            tokens.add((Object)new RawTok(t.kind == Tokens.TokenKind.STRINGLITERAL ? "\"" + t.stringVal() + "\"" : null, t.kind, t.pos, t.endPos));
            last = t.endPos;
        }
        if (last < end) {
            tokens.add((Object)new RawTok(null, null, last, end));
        }
        return tokens.build();
    }

    private JavacTokens() {
    }

    static class AccessibleScanner
    extends Scanner {
        protected AccessibleScanner(ScannerFactory fac, JavaTokenizer tokenizer) {
            super(fac, tokenizer);
        }
    }

    static class CommentSavingTokenizer
    extends JavaTokenizer {
        private static final Method GET_RAW_CHARACTERS_METHOD = CommentSavingTokenizer.getRawCharactersMethod();

        private static @Nullable Method getRawCharactersMethod() {
            try {
                return JavaTokenizer.BasicComment.class.getMethod("getRawCharacters", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        static int commentLength(Tokens.Comment comment) {
            if (comment instanceof JavaTokenizer.BasicComment && GET_RAW_CHARACTERS_METHOD != null) {
                try {
                    return ((char[])GET_RAW_CHARACTERS_METHOD.invoke((Object)((JavaTokenizer.BasicComment)comment), new Object[0])).length;
                }
                catch (ReflectiveOperationException e) {
                    throw new LinkageError(e.getMessage(), e);
                }
            }
            return comment.getText().length();
        }

        CommentSavingTokenizer(ScannerFactory fac, char[] buffer, int length) {
            super(fac, buffer, length);
        }

        @Override
        protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
            char[] buf = this.getRawCharactersReflectively(pos, endPos);
            return new CommentWithTextAndPosition(pos, endPos, new AccessibleReader(this.fac, buf, buf.length), style);
        }

        private char[] getRawCharactersReflectively(int beginIndex, int endIndex) {
            Object instance;
            try {
                instance = JavaTokenizer.class.getDeclaredField("reader").get(this);
            }
            catch (ReflectiveOperationException e) {
                instance = this;
            }
            try {
                return (char[])instance.getClass().getMethod("getRawCharacters", Integer.TYPE, Integer.TYPE).invoke(instance, beginIndex, endIndex);
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError(e.getMessage(), e);
            }
        }
    }

    static class RawTok {
        private final String stringVal;
        private final Tokens.TokenKind kind;
        private final int pos;
        private final int endPos;

        RawTok(String stringVal, Tokens.TokenKind kind, int pos, int endPos) {
            Preconditions.checkElementIndex((int)pos, (int)endPos, (String)"pos");
            Preconditions.checkArgument((pos < endPos ? 1 : 0) != 0, (String)"expected pos (%s) < endPos (%s)", (int)pos, (int)endPos);
            this.stringVal = stringVal;
            this.kind = kind;
            this.pos = pos;
            this.endPos = endPos;
        }

        public Tokens.TokenKind kind() {
            return this.kind;
        }

        public int pos() {
            return this.pos;
        }

        public int endPos() {
            return this.endPos;
        }

        public String stringVal() {
            return this.stringVal;
        }
    }

    static class AccessibleReader
    extends UnicodeReader {
        protected AccessibleReader(ScannerFactory fac, char[] buffer, int length) {
            super(fac, buffer, length);
        }
    }

    static class CommentWithTextAndPosition
    implements Tokens.Comment {
        private final int pos;
        private final int endPos;
        private final AccessibleReader reader;
        private final Tokens.Comment.CommentStyle style;
        private String text = null;

        public CommentWithTextAndPosition(int pos, int endPos, AccessibleReader reader, Tokens.Comment.CommentStyle style) {
            this.pos = pos;
            this.endPos = endPos;
            this.reader = reader;
            this.style = style;
        }

        @Override
        public int getSourcePos(int index) {
            Preconditions.checkArgument((0 <= index && index < this.endPos - this.pos ? 1 : 0) != 0, (String)"Expected %s in the range [0, %s)", (int)index, (int)(this.endPos - this.pos));
            return this.pos + index;
        }

        @Override
        public Tokens.Comment.CommentStyle getStyle() {
            return this.style;
        }

        @Override
        public String getText() {
            String text = this.text;
            if (text == null) {
                this.text = text = new String(this.reader.getRawCharacters());
            }
            return text;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        public String toString() {
            return String.format("Comment: '%s'", this.getText());
        }
    }
}

