/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.match;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.impl.FeasibleTransform;
import com.thaiopensource.relaxng.impl.MatchablePatternImpl;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.match.IncorrectSchemaException;
import com.thaiopensource.relaxng.match.MatchablePattern;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.SubParseable;
import com.thaiopensource.relaxng.parse.compact.CompactParseable;
import com.thaiopensource.relaxng.parse.compact.UriOpenerImpl;
import com.thaiopensource.relaxng.parse.sax.SAXParseable;
import com.thaiopensource.relaxng.parse.sax.UriResolverImpl;
import com.thaiopensource.xml.sax.Resolver;
import java.io.IOException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class MatchablePatternLoader {
    public static final int COMPACT_SYNTAX_FLAG = 1;
    public static final int FEASIBLE_FLAG = 2;

    public MatchablePattern load(SAXSource sAXSource, URIResolver uRIResolver, ErrorHandler errorHandler, DatatypeLibraryFactory datatypeLibraryFactory, int n) throws IOException, SAXException, IncorrectSchemaException {
        SubParseable subParseable;
        SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        Resolver resolver = Resolver.newInstance(uRIResolver);
        if ((n & 1) != 0) {
            subParseable = new CompactParseable(sAXSource.getInputSource(), new UriOpenerImpl(resolver), errorHandler);
        } else {
            if (sAXSource.getXMLReader() == null) {
                sAXSource = new SAXSource(resolver.createXMLReader(), sAXSource.getInputSource());
            }
            subParseable = new SAXParseable(sAXSource, new UriResolverImpl(resolver), errorHandler);
        }
        if (datatypeLibraryFactory == null) {
            datatypeLibraryFactory = new DatatypeLibraryLoader();
        }
        try {
            Pattern pattern = SchemaBuilderImpl.parse(subParseable, errorHandler, datatypeLibraryFactory, schemaPatternBuilder, false);
            if ((n & 2) != 0) {
                pattern = FeasibleTransform.transform(schemaPatternBuilder, pattern);
            }
            return new MatchablePatternImpl(schemaPatternBuilder, pattern);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            throw new IncorrectSchemaException();
        }
    }
}

