/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect.fields;

import java.util.Map;
import java.util.regex.Matcher;
import org.logstash.Event;
import org.logstash.dissect.Delimiter;
import org.logstash.dissect.ValueResolver;
import org.logstash.dissect.fields.AbstractField;
import org.logstash.dissect.fields.Field;

public final class AppendField
extends AbstractField {
    private AppendField(int id, String name, String suffix, int ord, Delimiter previous, Delimiter next) {
        super(id, name, suffix, ord, previous, next);
    }

    public static Field create(int id, String name, String suffix, Delimiter previous, Delimiter next) {
        Matcher m = ORDINAL_REGEX.matcher(suffix);
        if (m.find()) {
            return new AppendField(id, name, suffix, 100 + Integer.parseInt(m.group()), previous, next);
        }
        return new AppendField(id, name, suffix, 100, previous, next);
    }

    @Override
    public boolean saveable() {
        return true;
    }

    @Override
    public void append(Map<String, Object> keyValueMap, ValueResolver values) {
        if (keyValueMap.containsKey(this.name())) {
            Object old = keyValueMap.get(this.name());
            keyValueMap.put(this.name(), old.toString() + this.joinString() + values.get(this.id()));
        } else {
            keyValueMap.put(this.name(), values.get(this.id()));
        }
    }

    @Override
    public void append(Event event, ValueResolver values) {
        if (event.includes(this.name())) {
            Object old = event.getField(this.name());
            event.setField(this.name(), (Object)(old.toString() + this.joinString() + values.get(this.id())));
        } else {
            event.setField(this.name(), (Object)values.get(this.id()));
        }
    }

    public String toString() {
        return this.buildToString(this.getClass().getName());
    }
}

