/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XSLDecimalFormat
extends StyleElement {
    boolean prepared = false;
    String name;
    String decimalSeparator;
    String groupingSeparator;
    String infinity;
    String minusSign;
    String NaN;
    String percent;
    String perMille;
    String zeroDigit;
    String digit;
    String patternSeparator;
    DecimalSymbols symbols;

    public boolean isDeclaration() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                this.name = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("decimal-separator")) {
                this.decimalSeparator = atts.getValue(a);
                continue;
            }
            if (f.equals("grouping-separator")) {
                this.groupingSeparator = atts.getValue(a);
                continue;
            }
            if (f.equals("infinity")) {
                this.infinity = atts.getValue(a);
                continue;
            }
            if (f.equals("minus-sign")) {
                this.minusSign = atts.getValue(a);
                continue;
            }
            if (f.equals("NaN")) {
                this.NaN = atts.getValue(a);
                continue;
            }
            if (f.equals("percent")) {
                this.percent = atts.getValue(a);
                continue;
            }
            if (f.equals("per-mille")) {
                this.perMille = atts.getValue(a);
                continue;
            }
            if (f.equals("zero-digit")) {
                this.zeroDigit = atts.getValue(a);
                continue;
            }
            if (f.equals("digit")) {
                this.digit = atts.getValue(a);
                continue;
            }
            if (f.equals("pattern-separator")) {
                this.patternSeparator = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkTopLevel("XTSE0010", false);
        this.checkEmpty();
        int precedence = decl.getPrecedence();
        if (this.symbols == null) {
            return;
        }
        if (this.decimalSeparator != null) {
            this.symbols.setProperty(0, this.decimalSeparator, precedence);
        }
        if (this.groupingSeparator != null) {
            this.symbols.setProperty(1, this.groupingSeparator, precedence);
        }
        if (this.infinity != null) {
            this.symbols.setProperty(8, this.infinity, precedence);
        }
        if (this.minusSign != null) {
            this.symbols.setProperty(3, this.minusSign, precedence);
        }
        if (this.NaN != null) {
            this.symbols.setProperty(9, this.NaN, precedence);
        }
        if (this.percent != null) {
            this.symbols.setProperty(4, this.percent, precedence);
        }
        if (this.perMille != null) {
            this.symbols.setProperty(5, this.perMille, precedence);
        }
        if (this.zeroDigit != null) {
            this.symbols.setProperty(6, this.zeroDigit, precedence);
        }
        if (this.digit != null) {
            this.symbols.setProperty(2, this.digit, precedence);
        }
        if (this.patternSeparator != null) {
            this.symbols.setProperty(7, this.patternSeparator, precedence);
        }
    }

    public void index(ComponentDeclaration decl, StylesheetPackage top) throws XPathException {
        this.prepareAttributes();
        DecimalFormatManager dfm = this.getCompilation().getStylesheetPackage().getDecimalFormatManager();
        if (this.name == null) {
            this.symbols = dfm.getDefaultDecimalFormat();
        } else {
            try {
                StructuredQName formatName = this.makeQName(this.name);
                this.symbols = dfm.obtainNamedDecimalFormat(formatName);
                this.symbols.setHostLanguage(50);
            }
            catch (XPathException err) {
                this.compileError("Invalid decimal format name. " + err.getMessage(), "XTSE0020");
            }
            catch (NamespaceException err) {
                this.compileError("Invalid decimal format name. " + err.getMessage(), "XTSE0280");
            }
        }
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
    }
}

