/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.trans.XPathException;

public final class AxisInfo {
    public static final byte ANCESTOR = 0;
    public static final byte ANCESTOR_OR_SELF = 1;
    public static final byte ATTRIBUTE = 2;
    public static final byte CHILD = 3;
    public static final byte DESCENDANT = 4;
    public static final byte DESCENDANT_OR_SELF = 5;
    public static final byte FOLLOWING = 6;
    public static final byte FOLLOWING_SIBLING = 7;
    public static final byte NAMESPACE = 8;
    public static final byte PARENT = 9;
    public static final byte PRECEDING = 10;
    public static final byte PRECEDING_SIBLING = 11;
    public static final byte SELF = 12;
    public static final byte PRECEDING_OR_ANCESTOR = 13;
    public static final short[] principalNodeType = new short[]{1, 1, 2, 1, 1, 1, 1, 1, 13, 1, 1, 1, 1, 1};
    public static final boolean[] isForwards = new boolean[]{false, false, true, true, true, true, true, true, true, true, false, false, true, false};
    public static final boolean[] isPeerAxis = new boolean[]{false, false, true, true, false, false, false, true, true, true, false, true, true, false};
    public static final boolean[] isSubtreeAxis = new boolean[]{false, false, true, true, true, true, false, false, true, false, false, false, true, false};
    public static final String[] axisName = new String[]{"ancestor", "ancestor-or-self", "attribute", "child", "descendant", "descendant-or-self", "following", "following-sibling", "namespace", "parent", "preceding", "preceding-sibling", "self", "preceding-or-ancestor"};
    private static final int DOC = 512;
    private static final int ELE = 2;
    private static final int ATT = 4;
    private static final int TEX = 8;
    private static final int PIN = 128;
    private static final int COM = 256;
    private static final int NAM = 8192;
    private static int[] voidAxisTable = new int[]{512, 0, 9100, 8588, 8588, 0, 512, 8708, 9100, 512, 512, 8708, 0};
    private static int[] nodeKindTable = new int[]{514, 9102, 4, 394, 394, 9102, 394, 394, 8192, 514, 906, 394, 9102};
    public static byte[] inverseAxis = new byte[]{4, 5, 9, 9, 0, 1, 10, 11, 9, 3, 6, 7, 12};

    private AxisInfo() {
    }

    public static byte getAxisNumber(String name) throws XPathException {
        if (name.equals("ancestor")) {
            return 0;
        }
        if (name.equals("ancestor-or-self")) {
            return 1;
        }
        if (name.equals("attribute")) {
            return 2;
        }
        if (name.equals("child")) {
            return 3;
        }
        if (name.equals("descendant")) {
            return 4;
        }
        if (name.equals("descendant-or-self")) {
            return 5;
        }
        if (name.equals("following")) {
            return 6;
        }
        if (name.equals("following-sibling")) {
            return 7;
        }
        if (name.equals("namespace")) {
            return 8;
        }
        if (name.equals("parent")) {
            return 9;
        }
        if (name.equals("preceding")) {
            return 10;
        }
        if (name.equals("preceding-sibling")) {
            return 11;
        }
        if (name.equals("self")) {
            return 12;
        }
        throw new XPathException("Unknown axis name: " + name);
    }

    public static boolean isAlwaysEmpty(int axis, int nodeKind) {
        return (voidAxisTable[axis] & 1 << nodeKind) != 0;
    }

    public static boolean containsNodeKind(int axis, int nodeKind) {
        return (nodeKindTable[axis] & 1 << nodeKind) != 0;
    }
}

