/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
extends SystemFunctionCall
implements Callable {
    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault(visitor);
        return this.simplifyArguments(visitor);
    }

    @Override
    public StringValue evaluateItem(XPathContext context) throws XPathException {
        NodeInfo node = (NodeInfo)this.argument[0].evaluateItem(context);
        if (node == null) {
            return null;
        }
        return Path.makePath(node, context);
    }

    @Override
    public ZeroOrOne<StringValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo node;
        NodeInfo nodeInfo = node = arguments.length == 0 ? this.getContextNode(context) : (NodeInfo)arguments[0].head();
        if (node == null) {
            return ZeroOrOne.empty();
        }
        return new ZeroOrOne<StringValue>(Path.makePath(node, context));
    }

    private static StringValue makePath(NodeInfo node, XPathContext context) throws XPathException {
        NodeInfo n;
        if (node.getNodeKind() == 9) {
            return StringValue.makeStringValue("/");
        }
        FastStringBuffer fsb = new FastStringBuffer(256);
        AxisIterator iter = node.iterateAxis((byte)1);
        block9: while ((n = iter.next()) != null) {
            if (n.getParent() == null) {
                if (n.getNodeKind() == 9) {
                    return new StringValue(fsb);
                }
                fsb.prepend("Q{http://www.w3.org/2005/xpath-functions}root()");
                return new StringValue(fsb);
            }
            FastStringBuffer fsb2 = new FastStringBuffer(256);
            switch (n.getNodeKind()) {
                case 9: {
                    return new StringValue(fsb);
                }
                case 1: {
                    fsb2.append("/Q{");
                    fsb2.append(n.getURI());
                    fsb2.append("}");
                    fsb2.append(n.getLocalPart());
                    fsb2.append("[" + Navigator.getNumberSimple(n, context) + "]");
                    fsb2.append(fsb);
                    fsb = fsb2;
                    continue block9;
                }
                case 2: {
                    fsb2.append("/@");
                    String attURI = n.getURI();
                    if (!"".equals(attURI)) {
                        fsb2.append("Q{");
                        fsb2.append(attURI);
                        fsb2.append("}");
                    }
                    fsb2.append(n.getLocalPart());
                    fsb2.append(fsb);
                    fsb = fsb2;
                    continue block9;
                }
                case 3: {
                    fsb2.append("/text()[");
                    fsb2.append(Navigator.getNumberSimple(n, context) + "]");
                    fsb2.append(fsb);
                    fsb = fsb2;
                    continue block9;
                }
                case 8: {
                    fsb2.append("/comment()[");
                    fsb2.append(Navigator.getNumberSimple(n, context) + "]");
                    fsb2.append(fsb);
                    fsb = fsb2;
                    continue block9;
                }
                case 7: {
                    fsb2.append("/processing-instruction(");
                    fsb2.append(n.getLocalPart());
                    fsb2.append(")[");
                    fsb2.append(Navigator.getNumberSimple(n, context) + "]");
                    fsb2.append(fsb);
                    fsb = fsb2;
                    continue block9;
                }
                case 13: {
                    fsb2.append("/namespace::");
                    if (n.getLocalPart().length() == 0) {
                        fsb2.append("*[Q{http://www.w3.org/2005/xpath-functions}local-name()=\"\"]");
                    } else {
                        fsb.append(n.getLocalPart());
                    }
                    fsb2.append(fsb);
                    fsb = fsb2;
                    continue block9;
                }
            }
            throw new AssertionError();
        }
        fsb.prepend("Q{http://www.w3.org/2005/xpath-functions}root()");
        return new StringValue(fsb);
    }
}

