/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceForPrefix
extends SystemFunctionCall
implements Callable {
    @Override
    public AnyURIValue evaluateItem(XPathContext context) throws XPathException {
        NodeInfo element = (NodeInfo)this.argument[1].evaluateItem(context);
        StringValue p = (StringValue)this.argument[0].evaluateItem(context);
        return NamespaceForPrefix.namespaceUriForPrefix(p, element);
    }

    @Override
    public ZeroOrOne<AnyURIValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
        AnyURIValue result = NamespaceForPrefix.namespaceUriForPrefix((StringValue)arguments[0].head(), (NodeInfo)arguments[1].head());
        return new ZeroOrOne<AnyURIValue>(result);
    }

    private static AnyURIValue namespaceUriForPrefix(StringValue p, NodeInfo element) {
        InscopeNamespaceResolver resolver = new InscopeNamespaceResolver(element);
        String prefix = p == null ? "" : p.getStringValue();
        String uri = resolver.getURIForPrefix(prefix, true);
        if (uri == null || uri.length() == 0) {
            return null;
        }
        return new AnyURIValue(uri);
    }
}

