/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class AccessorFn
extends SystemFunctionCall {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DAY = 3;
    public static final int HOURS = 4;
    public static final int MINUTES = 5;
    public static final int SECONDS = 6;
    public static final int TIMEZONE = 7;
    public static final int LOCALNAME = 8;
    public static final int NAMESPACE = 9;
    public static final int PREFIX = 10;
    public static final int MICROSECONDS = 11;
    public static final int WHOLE_SECONDS = 12;
    public static final int YEAR_ALLOWING_ZERO = 13;
    int component;

    public void setDetails(StandardFunction.Entry entry) {
        super.setDetails(entry);
        this.component = this.operation >> 16 & 0xFFFF;
    }

    public IntegerValue[] getIntegerBounds() {
        switch (this.component) {
            case 1: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-100000L), Int64Value.makeIntegerValue(100000L)};
            }
            case 2: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-11L), Int64Value.makeIntegerValue(11L)};
            }
            case 3: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-31L), Int64Value.makeIntegerValue(31L)};
            }
            case 4: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-24L), Int64Value.makeIntegerValue(24L)};
            }
            case 5: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-59L), Int64Value.makeIntegerValue(59L)};
            }
            case 6: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-59L), Int64Value.makeIntegerValue(59L)};
            }
        }
        return null;
    }

    public int getRequiredComponent() {
        return this.component;
    }

    public String getRequiredComponentAsString() {
        String[] components = new String[]{"", "YEAR", "MONTH", "DAY", "HOURS", "MINUTES", "SECONDS", "TIMEZONE", "LOCALNAME", "NAMESPACE", "PREFIX", "MICROSECONDS", "WHOLE_SECONDS", "YEAR_ALLOWING_ZERO"};
        return components[this.component];
    }

    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        AtomicValue arg = (AtomicValue)this.argument[0].evaluateItem(context);
        if (arg == null) {
            return null;
        }
        return arg.getComponent(this.component);
    }

    public Expression copy() {
        AccessorFn c = (AccessorFn)super.copy();
        c.component = c.operation >> 16 & 0xFFFF;
        return c;
    }

    public AtomicValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        return ((AtomicValue)arguments[0].head()).getComponent(this.component);
    }
}

