/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryCatch
extends Expression {
    private Expression tryExpr;
    private List<CatchClause> catchClauses = new ArrayList<CatchClause>();

    public TryCatch(Expression tryExpr) {
        this.tryExpr = tryExpr;
    }

    public void addCatchExpression(QNameTest test, Expression catchExpr) {
        CatchClause clause = new CatchClause();
        clause.catchExpr = catchExpr;
        clause.nameTest = test;
        this.catchClauses.add(clause);
    }

    public Expression getTryExpr() {
        return this.tryExpr;
    }

    public List<CatchClause> getCatchClauses() {
        return this.catchClauses;
    }

    @Override
    public int computeCardinality() {
        int card = this.tryExpr.getCardinality();
        for (CatchClause catchClause : this.catchClauses) {
            card = Cardinality.union(card, catchClause.catchExpr.getCardinality());
        }
        return card;
    }

    @Override
    public ItemType getItemType() {
        ItemType type = this.tryExpr.getItemType();
        for (CatchClause catchClause : this.catchClauses) {
            type = Type.getCommonSuperType(type, catchClause.catchExpr.getItemType());
        }
        return type;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.tryExpr = visitor.typeCheck(this.tryExpr, contextInfo);
        for (CatchClause clause : this.catchClauses) {
            Expression e0 = clause.catchExpr;
            Expression e1 = visitor.typeCheck(e0, contextInfo);
            if (e0 != e1) {
                ExpressionTool.copyLocationInfo(e0, e1);
            }
            clause.catchExpr = e1;
        }
        return this;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>();
        list.add(new Operand(this.tryExpr, OperandRole.SAME_FOCUS_ACTION));
        for (CatchClause cc : this.catchClauses) {
            list.add(new Operand(cc.catchExpr, OperandRole.SAME_FOCUS_ACTION));
        }
        return list;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        if (offer.action != 14 && offer.action != 10) {
            Expression exp = offer.accept(parent, this);
            if (exp != null) {
                return exp;
            }
            this.tryExpr = this.doPromotion(this.tryExpr, offer);
            for (CatchClause clause : this.catchClauses) {
                clause.catchExpr = this.doPromotion(clause.catchExpr, offer);
            }
            return this;
        }
        return this;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.tryExpr == original) {
            this.tryExpr = replacement;
            found = true;
        }
        for (CatchClause clause : this.catchClauses) {
            if (clause.catchExpr != original) continue;
            clause.catchExpr = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression copy() {
        TryCatch t2 = new TryCatch(this.tryExpr.copy());
        for (CatchClause clause : this.catchClauses) {
            t2.addCatchExpression(clause.nameTest, clause.catchExpr.copy());
        }
        return t2;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        XPathContextMinor c1 = c.newMinorContext();
        try {
            return ExpressionTool.eagerEvaluate(this.tryExpr, c1).head();
        }
        catch (XPathException err) {
            if (err.isGlobalError()) {
                err.setIsGlobalError(false);
            } else {
                StructuredQName code = err.getErrorCodeQName();
                for (CatchClause clause : this.catchClauses) {
                    if (!clause.nameTest.matches(code)) continue;
                    Expression caught = clause.catchExpr;
                    XPathContextMinor c2 = c.newMinorContext();
                    c2.setCurrentException(err);
                    return caught.evaluateItem(c2);
                }
            }
            err.setHasBeenReported(false);
            throw err;
        }
    }

    @Override
    public SequenceIterator iterate(XPathContext c) throws XPathException {
        XPathContextMajor c1 = c.newContext();
        c1.createThreadManager();
        try {
            Sequence v = ExpressionTool.eagerEvaluate(this.tryExpr, c1);
            c1.notifyChildThreads();
            return v.iterate();
        }
        catch (XPathException err) {
            if (err.isGlobalError()) {
                err.setIsGlobalError(false);
            } else {
                StructuredQName code = err.getErrorCodeQName();
                for (CatchClause clause : this.catchClauses) {
                    if (!clause.nameTest.matches(code)) continue;
                    Expression caught = clause.catchExpr;
                    XPathContextMinor c2 = c.newMinorContext();
                    c2.setCurrentException(err);
                    return caught.iterate(c2);
                }
            }
            err.setHasBeenReported(false);
            throw err;
        }
    }

    @Override
    public String getExpressionName() {
        return "tryCatch";
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("tryCatch");
        out.startSubsidiaryElement("try");
        this.tryExpr.explain(out);
        out.endSubsidiaryElement();
        for (CatchClause clause : this.catchClauses) {
            out.startSubsidiaryElement("catch");
            out.emitAttribute("error", clause.nameTest.toString());
            clause.catchExpr.explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    public static class CatchClause {
        public int slotNumber = -1;
        public Expression catchExpr;
        public QNameTest nameTest;
    }
}

