/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.impl.store.raw.data.RecordId;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class StoredRecordHeader {
    private static final byte RECORD_DELETED = 1;
    private static final byte RECORD_OVERFLOW = 2;
    private static final byte RECORD_HAS_FIRST_FIELD = 4;
    private static final byte RECORD_VALID_MASK = 15;
    public static final int MAX_OVERFLOW_ONLY_REC_SIZE = 17;
    protected int id;
    private byte status;
    protected int numberFields;
    protected RecordHandle handle;
    private OverflowInfo overflow;

    public StoredRecordHeader() {
    }

    public StoredRecordHeader(int id, int numberFields) {
        this.setId(id);
        this.setNumberFields(numberFields);
    }

    public StoredRecordHeader(byte[] data, int offset) {
        this.read(data, offset);
    }

    public StoredRecordHeader(StoredRecordHeader loadTargetFrom) {
        this.status = loadTargetFrom.status;
        this.id = loadTargetFrom.id;
        this.numberFields = loadTargetFrom.numberFields;
        this.handle = null;
        if (loadTargetFrom.overflow != null) {
            this.overflow = new OverflowInfo(loadTargetFrom.overflow);
        }
    }

    protected RecordHandle getHandle(PageKey pageId, int current_slot) {
        if (this.handle == null) {
            this.handle = new RecordId(pageId, this.id, current_slot);
        }
        return this.handle;
    }

    public final int getId() {
        return this.id;
    }

    public int getNumberFields() {
        return this.numberFields;
    }

    public long getOverflowPage() {
        return this.overflow == null ? 0L : this.overflow.overflowPage;
    }

    public int getOverflowId() {
        return this.overflow == null ? 0 : this.overflow.overflowId;
    }

    public int getFirstField() {
        return this.overflow == null ? 0 : this.overflow.firstField;
    }

    public final boolean hasOverflow() {
        return (this.status & 2) == 2;
    }

    protected final boolean hasFirstField() {
        return (this.status & 4) == 4;
    }

    public final boolean isDeleted() {
        return (this.status & 1) == 1;
    }

    public int size() {
        int len;
        int n = this.id <= 63 ? 2 : (len = this.id <= 16383 ? 3 : 5);
        if ((this.status & 6) == 0) {
            len += this.numberFields <= 63 ? 1 : (this.numberFields <= 16383 ? 2 : 4);
        } else if ((this.status & 2) == 0) {
            len += CompressedNumber.sizeInt(this.numberFields);
            len += CompressedNumber.sizeInt(this.overflow.firstField);
        } else {
            len += CompressedNumber.sizeLong(this.overflow.overflowPage);
            len += CompressedNumber.sizeInt(this.overflow.overflowId);
            if (this.hasFirstField()) {
                len += CompressedNumber.sizeInt(this.overflow.firstField);
                len += CompressedNumber.sizeInt(this.numberFields);
            }
        }
        return len;
    }

    public int setDeleted(boolean deleteTrue) {
        int retCode = 0;
        if (deleteTrue) {
            if (!this.isDeleted()) {
                retCode = 1;
                this.status = (byte)(this.status | 1);
            }
        } else if (this.isDeleted()) {
            retCode = -1;
            this.status = (byte)(this.status & 0xFFFFFFFE);
        }
        return retCode;
    }

    public void setFirstField(int firstField) {
        if (this.overflow == null) {
            this.overflow = new OverflowInfo();
        }
        this.overflow.firstField = firstField;
        this.status = (byte)(this.status | 4);
    }

    public final void setId(int id) {
        this.id = id;
    }

    public void setOverflowDetails(RecordHandle overflowHandle) {
        if (this.overflow == null) {
            this.overflow = new OverflowInfo();
        }
        this.overflow.overflowPage = overflowHandle.getPageNumber();
        this.overflow.overflowId = overflowHandle.getId();
    }

    public void setOverflowFields(StoredRecordHeader loadFromTarget) {
        if (this.overflow == null) {
            this.overflow = new OverflowInfo();
        }
        this.status = (byte)(loadFromTarget.status | 2);
        this.id = loadFromTarget.id;
        this.numberFields = loadFromTarget.numberFields;
        this.overflow.firstField = loadFromTarget.overflow.firstField;
        this.handle = null;
    }

    public final void setNumberFields(int numberFields) {
        this.numberFields = numberFields;
    }

    public int write(OutputStream out) throws IOException {
        if ((this.status & 0xFFFFFFF0) != 0) {
            SanityManager.THROWASSERT((String)("Invalid status in StoredRecordHeaader = " + this.status));
        }
        int len = 1;
        out.write(this.status);
        len += CompressedNumber.writeInt(out, this.id);
        if (this.hasOverflow()) {
            len += CompressedNumber.writeLong(out, this.overflow.overflowPage);
            len += CompressedNumber.writeInt(out, this.overflow.overflowId);
        }
        if (this.hasFirstField()) {
            len += CompressedNumber.writeInt(out, this.overflow.firstField);
        }
        if (!this.hasOverflow() || this.hasFirstField()) {
            len += CompressedNumber.writeInt(out, this.numberFields);
        }
        return len;
    }

    public void read(ObjectInput in) throws IOException {
        int s = in.read();
        if (s < 0) {
            throw new EOFException();
        }
        this.status = (byte)s;
        if ((s & 0xFFFFFFF0) != 0) {
            SanityManager.THROWASSERT((String)("Invalid status in StoredRecordHeader = " + s));
        }
        this.id = CompressedNumber.readInt(in);
        this.overflow = this.hasOverflow() || this.hasFirstField() ? new OverflowInfo() : null;
        if (this.hasOverflow()) {
            this.overflow.overflowPage = CompressedNumber.readLong(in);
            this.overflow.overflowId = CompressedNumber.readInt(in);
        }
        if (this.hasFirstField()) {
            this.overflow.firstField = CompressedNumber.readInt(in);
        }
        this.numberFields = !this.hasOverflow() || this.hasFirstField() ? CompressedNumber.readInt(in) : 0;
        this.handle = null;
    }

    private int readOverFlowPage(byte[] data, int offset) {
        byte int_value;
        if (((int_value = data[offset++]) & 0xFFFFFFC0) == 0) {
            this.overflow.overflowPage = int_value << 8 | data[offset] & 0xFF;
            return 2;
        }
        if ((int_value & 0x80) == 0) {
            this.overflow.overflowPage = (int_value & 0x3F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
            return 4;
        }
        this.overflow.overflowPage = (long)(int_value & 0x7F) << 56 | (long)(data[offset++] & 0xFF) << 48 | (long)(data[offset++] & 0xFF) << 40 | (long)(data[offset++] & 0xFF) << 32 | (long)(data[offset++] & 0xFF) << 24 | (long)(data[offset++] & 0xFF) << 16 | (long)(data[offset++] & 0xFF) << 8 | (long)(data[offset] & 0xFF);
        return 8;
    }

    private int readOverFlowId(byte[] data, int offset) {
        byte value;
        if (((value = data[offset++]) & 0xFFFFFFC0) == 0) {
            this.overflow.overflowId = value;
            return 1;
        }
        if ((value & 0x80) == 0) {
            this.overflow.overflowId = (value & 0x3F) << 8 | data[offset] & 0xFF;
            return 2;
        }
        this.overflow.overflowId = (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
        return 4;
    }

    private int readFirstField(byte[] data, int offset) {
        byte value;
        if (((value = data[offset++]) & 0xFFFFFFC0) == 0) {
            this.overflow.firstField = value;
            return 1;
        }
        if ((value & 0x80) == 0) {
            this.overflow.firstField = (value & 0x3F) << 8 | data[offset] & 0xFF;
            return 2;
        }
        this.overflow.firstField = (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
        return 4;
    }

    private void readNumberFields(byte[] data, int offset) {
        int value;
        this.numberFields = ((value = data[offset++]) & 0xFFFFFFC0) == 0 ? value : ((value & 0x80) == 0 ? (value & 0x3F) << 8 | data[offset] & 0xFF : (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF);
    }

    private void read(byte[] data, int offset) {
        int value;
        this.status = data[offset++];
        this.id = ((value = data[offset++]) & 0xFFFFFFC0) == 0 ? value : ((value & 0x80) == 0 ? (value & 0x3F) << 8 | data[offset++] & 0xFF : (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset++] & 0xFF);
        if ((this.status & 6) == 0) {
            this.overflow = null;
            this.readNumberFields(data, offset);
        } else if ((this.status & 2) == 0) {
            this.overflow = new OverflowInfo();
            offset += this.readFirstField(data, offset);
            this.readNumberFields(data, offset);
        } else {
            this.overflow = new OverflowInfo();
            offset += this.readOverFlowPage(data, offset);
            offset += this.readOverFlowId(data, offset);
            if (this.hasFirstField()) {
                offset += this.readFirstField(data, offset);
                this.readNumberFields(data, offset);
            } else {
                this.numberFields = 0;
            }
        }
        this.handle = null;
    }

    public static final int getStoredSizeRecordId(int record_id) {
        return CompressedNumber.sizeInt(record_id);
    }

    public String toString() {
        String str = "recordHeader: Id=" + this.getId();
        str = str + "\n  isDeleted     = " + this.isDeleted();
        str = str + "\n  hasOverflow   = " + this.hasOverflow();
        str = str + "\n  hasFirstField = " + this.hasFirstField();
        str = str + "\n  numberFields  = " + this.getNumberFields();
        str = str + "\n  firstField    = " + this.getFirstField();
        str = str + "\n  overflowPage  = " + this.getOverflowPage();
        str = str + "\n  overflowId    = " + this.getOverflowId();
        str = str + "\n  header length = " + this.size();
        return str;
    }

    private static class OverflowInfo {
        private int overflowId;
        private long overflowPage;
        private int firstField;

        private OverflowInfo() {
        }

        private OverflowInfo(OverflowInfo from) {
            this.overflowId = from.overflowId;
            this.overflowPage = from.overflowPage;
            this.firstField = from.firstField;
        }
    }
}

