/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;
import org.apache.derby.shared.common.sanity.SanityManager;

public class XMLTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        return otherType.isXMLTypeId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return otherType.isXMLTypeId();
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        return otherType.isXMLTypeId();
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.XMLDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        if (formatId == 456) {
            return "org.apache.derby.iapi.types.XML";
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in getCorrespondingPrimitiveTypeName(): " + formatId));
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return -1;
    }

    @Override
    String nullMethodName() {
        if (this.getStoredFormatIdFromTypeId() != 456) {
            SanityManager.THROWASSERT((String)("unexpected formatId in nullMethodName(): " + this.getStoredFormatIdFromTypeId()));
        }
        return "getNullXML";
    }

    @Override
    protected String dataValueMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        if (formatId == 456) {
            return "getXMLDataValue";
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in dataValueMethodName() - " + formatId));
        return null;
    }
}

