/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryLogicalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class AndNode
extends BinaryLogicalOperatorNode {
    AndNode(ValueNode leftOperand, ValueNode rightOperand, ContextManager cm) throws StandardException {
        super(leftOperand, rightOperand, "and", cm);
        this.shortCircuitValue = false;
    }

    AndNode(ValueNode leftOperand, ValueNode rightOperand, String methodName, ContextManager cm) throws StandardException {
        super(leftOperand, rightOperand, methodName, cm);
        this.shortCircuitValue = false;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        super.bindExpression(fromList, subqueryList, aggregates);
        this.postBindFixup();
        return this;
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        if (this.leftOperand instanceof OrNode) {
            ((OrNode)this.leftOperand).setFirstOr();
        }
        this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (this.leftOperand instanceof AndNode) {
            this.changeToCNF(false);
        }
        this.rightOperand = this.rightOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        this.leftOperand = this.leftOperand.eliminateNots(underNotNode);
        this.rightOperand = this.rightOperand.eliminateNots(underNotNode);
        if (!underNotNode) {
            return this;
        }
        OrNode orNode = new OrNode(this.leftOperand, this.rightOperand, this.getContextManager());
        orNode.setType(this.getTypeServices());
        return orNode;
    }

    @Override
    ValueNode putAndsOnTop() throws StandardException {
        SanityManager.ASSERT((this.rightOperand != null ? 1 : 0) != 0, (String)"rightOperand is expected to be non-null");
        this.rightOperand = this.rightOperand.putAndsOnTop();
        return this;
    }

    @Override
    boolean verifyPutAndsOnTop() {
        boolean isValid = true;
        boolean bl = isValid = this.rightOperand instanceof AndNode || this.rightOperand.isBooleanTrue();
        if (this.rightOperand instanceof AndNode) {
            isValid = this.rightOperand.verifyPutAndsOnTop();
        }
        return isValid;
    }

    @Override
    ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        AndNode curAnd = this;
        if (!(this.rightOperand instanceof AndNode) && !this.rightOperand.isBooleanTrue()) {
            BooleanConstantNode trueNode = new BooleanConstantNode(true, this.getContextManager());
            AndNode newRightOperand = new AndNode(curAnd.getRightOperand(), trueNode, this.getContextManager());
            curAnd.setRightOperand(newRightOperand);
            newRightOperand.postBindFixup();
        }
        while (this.leftOperand instanceof AndNode) {
            ValueNode newLeft = ((AndNode)this.leftOperand).getLeftOperand();
            AndNode oldLeft = (AndNode)this.leftOperand;
            AndNode newRight = (AndNode)this.leftOperand;
            ValueNode oldRight = this.rightOperand;
            this.leftOperand = newLeft;
            this.rightOperand = newRight;
            newRight.setLeftOperand(oldLeft.getRightOperand());
            newRight.setRightOperand(oldRight);
        }
        this.leftOperand = this.leftOperand.changeToCNF(underTopAndNode);
        this.rightOperand = this.rightOperand.changeToCNF(underTopAndNode);
        return this;
    }

    @Override
    boolean verifyChangeToCNF() {
        boolean isValid = true;
        boolean bl = isValid = this.rightOperand instanceof AndNode || this.rightOperand.isBooleanTrue();
        if (this.rightOperand instanceof AndNode) {
            isValid = this.rightOperand.verifyChangeToCNF();
        }
        isValid = this.leftOperand instanceof AndNode ? false : isValid && this.leftOperand.verifyChangeToCNF();
        return isValid;
    }

    void postBindFixup() throws StandardException {
        this.setType(this.resolveLogicalBinaryOperator(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices()));
    }
}

