/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.error.StandardException;

public class SQLVarbit
extends SQLBit {
    @Override
    public String getTypeName() {
        return "VARCHAR () FOR BIT DATA";
    }

    @Override
    int getMaxMemoryUsage() {
        return 32672;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLVarbit();
    }

    @Override
    public int getTypeFormatId() {
        return 88;
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        int desiredWidth = desiredType.getMaximumWidth();
        byte[] sourceData = source.getBytes();
        this.setValue(sourceData);
        if (sourceData.length > desiredWidth) {
            this.setWidth(desiredWidth, 0, true);
        }
    }

    @Override
    public void setWidth(int desiredWidth, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.getValue() == null) {
            return;
        }
        int sourceWidth = this.dataValue.length;
        if (sourceWidth > desiredWidth) {
            if (errorOnTrunc) {
                for (int i = desiredWidth; i < this.dataValue.length; ++i) {
                    if (this.dataValue[i] == 32) continue;
                    throw StandardException.newException((String)"22001", (Object[])new Object[]{this.getTypeName(), StringUtil.formatForPrint(this.toString()), String.valueOf(desiredWidth)});
                }
            }
            this.truncate(sourceWidth, desiredWidth, !errorOnTrunc);
        }
    }

    public SQLVarbit() {
    }

    public SQLVarbit(byte[] val) {
        super(val);
    }

    @Override
    public int typePrecedence() {
        return 150;
    }
}

