/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class DataType
implements DataValueDescriptor,
Comparable {
    @Override
    public boolean getBoolean() throws StandardException {
        throw this.dataTypeConversion("boolean");
    }

    @Override
    public byte getByte() throws StandardException {
        throw this.dataTypeConversion("byte");
    }

    @Override
    public short getShort() throws StandardException {
        throw this.dataTypeConversion("short");
    }

    @Override
    public int getInt() throws StandardException {
        throw this.dataTypeConversion("int");
    }

    @Override
    public long getLong() throws StandardException {
        throw this.dataTypeConversion("long");
    }

    @Override
    public float getFloat() throws StandardException {
        throw this.dataTypeConversion("float");
    }

    @Override
    public double getDouble() throws StandardException {
        throw this.dataTypeConversion("double");
    }

    @Override
    public int typeToBigDecimal() throws StandardException {
        throw this.dataTypeConversion("java.math.BigDecimal");
    }

    @Override
    public byte[] getBytes() throws StandardException {
        throw this.dataTypeConversion("byte[]");
    }

    @Override
    public Date getDate(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Date");
    }

    @Override
    public Time getTime(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Time");
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Timestamp");
    }

    @Override
    public InputStream getStream() throws StandardException {
        throw this.dataTypeConversion("InputStream");
    }

    @Override
    public boolean hasStream() {
        return false;
    }

    @Override
    public String getTraceString() throws StandardException {
        return this.getString();
    }

    @Override
    public DataValueDescriptor recycle() {
        this.restoreToNull();
        return this;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    @Override
    public final BooleanDataValue isNullOp() {
        return SQLBoolean.truthValue(this.isNull());
    }

    @Override
    public final BooleanDataValue isNotNull() {
        return SQLBoolean.truthValue(!this.isNull());
    }

    @Override
    public void setValue(Time theValue) throws StandardException {
        this.setValue(theValue, (Calendar)null);
    }

    @Override
    public void setValue(Time theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Time");
    }

    @Override
    public void setValue(Timestamp theValue) throws StandardException {
        this.setValue(theValue, (Calendar)null);
    }

    @Override
    public void setValue(Timestamp theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Timestamp");
    }

    @Override
    public void setValue(Date theValue) throws StandardException {
        this.setValue(theValue, (Calendar)null);
    }

    @Override
    public void setValue(Date theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Date");
    }

    @Override
    public void setValue(Object theValue) throws StandardException {
        this.throwLangSetMismatch("java.lang.Object");
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.throwLangSetMismatch("java.lang.String");
    }

    @Override
    public void setValue(Blob theValue) throws StandardException {
        this.throwLangSetMismatch("java.sql.Blob");
    }

    @Override
    public void setValue(Clob theValue) throws StandardException {
        this.throwLangSetMismatch("java.sql.Clob");
    }

    @Override
    public void setValue(int theValue) throws StandardException {
        this.throwLangSetMismatch("int");
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        this.throwLangSetMismatch("double");
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        this.throwLangSetMismatch("float");
    }

    @Override
    public void setValue(short theValue) throws StandardException {
        this.throwLangSetMismatch("short");
    }

    @Override
    public void setValue(long theValue) throws StandardException {
        this.throwLangSetMismatch("long");
    }

    @Override
    public void setValue(byte theValue) throws StandardException {
        this.throwLangSetMismatch("byte");
    }

    @Override
    public void setValue(boolean theValue) throws StandardException {
        this.throwLangSetMismatch("boolean");
    }

    @Override
    public void setValue(byte[] theValue) throws StandardException {
        this.throwLangSetMismatch("byte[]");
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws StandardException {
        this.throwLangSetMismatch("java.math.BigDecimal");
    }

    @Override
    public final void setValue(DataValueDescriptor dvd) throws StandardException {
        if (dvd.isNull()) {
            this.setToNull();
            return;
        }
        try {
            this.setFrom(dvd);
        }
        catch (StandardException se) {
            String msgId = se.getMessageId();
            if ("22003".equals(msgId)) {
                throw this.outOfRange();
            }
            if ("22018".equals(msgId)) {
                throw this.invalidFormat();
            }
            throw se;
        }
    }

    protected void setFrom(DataValueDescriptor dvd) throws StandardException {
        throw StandardException.newException((String)"0A000.S", (Object[])new Object[0]);
    }

    @Override
    public void setToNull() {
        this.restoreToNull();
    }

    @Override
    public void setObjectForCast(Object theValue, boolean instanceOfResultType, String resultTypeClassName) throws StandardException {
        if (theValue == null) {
            this.setToNull();
            return;
        }
        if (!instanceOfResultType) {
            throw StandardException.newException((String)"XCL12.S", (Object[])new Object[]{theValue.getClass().getName(), this.getTypeName(resultTypeClassName)});
        }
        this.setObject(theValue);
    }

    void setObject(Object theValue) throws StandardException {
        this.genericSetObject(theValue);
    }

    String getTypeName(String className) {
        return this.getTypeName();
    }

    @Override
    public Object getObject() throws StandardException {
        throw this.dataTypeConversion("java.lang.Object");
    }

    void genericSetObject(Object theValue) throws StandardException {
        this.throwLangSetMismatch(theValue);
    }

    @Override
    public DataValueDescriptor cloneHolder() {
        return this.cloneValue(false);
    }

    public void throwLangSetMismatch(Object value) throws StandardException {
        this.throwLangSetMismatch(value.getClass().getName());
    }

    void throwLangSetMismatch(String argTypeName) throws StandardException {
        throw StandardException.newException((String)"XCL12.S", (Object[])new Object[]{argTypeName, this.getTypeName()});
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setObject(position, this.getObject());
    }

    @Override
    public void setInto(ResultSet rs, int position) throws SQLException, StandardException {
        rs.updateObject(position, this.getObject());
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.setValue(source);
    }

    @Override
    public int typePrecedence() {
        return -1;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) == 0);
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) != 0);
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) < 0);
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) > 0);
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) <= 0);
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) >= 0);
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return other.compare(DataType.flip(op), this, orderedNulls, unknownRV);
        }
        int result = this.compare(other);
        switch (op) {
            case 1: {
                return result < 0;
            }
            case 2: {
                return result == 0;
            }
            case 3: {
                return result <= 0;
            }
            case 4: {
                return result > 0;
            }
            case 5: {
                return result >= 0;
            }
        }
        SanityManager.THROWASSERT((String)"Invalid Operator");
        return false;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean nullsOrderedLow, boolean unknownRV) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return other.compare(DataType.flip(op), this, orderedNulls, nullsOrderedLow, unknownRV);
        }
        int result = this.compare(other, nullsOrderedLow);
        switch (op) {
            case 1: {
                return result < 0;
            }
            case 2: {
                return result == 0;
            }
            case 3: {
                return result <= 0;
            }
            case 4: {
                return result > 0;
            }
            case 5: {
                return result >= 0;
            }
        }
        SanityManager.THROWASSERT((String)"Invalid Operator");
        return false;
    }

    @Override
    public int compare(DataValueDescriptor other, boolean nullsOrderedLow) throws StandardException {
        if (this.isNull() || other.isNull()) {
            if (!this.isNull()) {
                return nullsOrderedLow ? 1 : -1;
            }
            if (!other.isNull()) {
                return nullsOrderedLow ? -1 : 1;
            }
            return 0;
        }
        return this.compare(other);
    }

    public int compareTo(Object otherDVD) {
        DataValueDescriptor other = (DataValueDescriptor)otherDVD;
        try {
            if (this.typePrecedence() < other.typePrecedence()) {
                return -1 * other.compare(this);
            }
            return this.compare(other);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((String)("Encountered error while trying to compare two DataValueDescriptors: " + se.getMessage()));
            return 0;
        }
    }

    protected static int flip(int operator) {
        switch (operator) {
            case 1: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 2: {
                return 2;
            }
        }
        SanityManager.THROWASSERT((String)"Attempting to flip an operator that is not expected to be flipped.");
        return operator;
    }

    @Override
    public DataValueDescriptor coalesce(DataValueDescriptor[] argumentsList, DataValueDescriptor returnValue) throws StandardException {
        SanityManager.ASSERT((argumentsList != null ? 1 : 0) != 0, (String)"argumentsList expected to be non-null");
        SanityManager.ASSERT((argumentsList.length > 1 ? 1 : 0) != 0, (String)"argumentsList.length expected to be > 1");
        for (int index = 0; index < argumentsList.length; ++index) {
            if (argumentsList[index].isNull()) continue;
            returnValue.setValue(argumentsList[index]);
            return returnValue;
        }
        returnValue.setToNull();
        return returnValue;
    }

    @Override
    public BooleanDataValue in(DataValueDescriptor left, DataValueDescriptor[] inList, boolean orderedList) throws StandardException {
        BooleanDataValue stop;
        BooleanDataValue retval = null;
        SanityManager.ASSERT((inList != null ? 1 : 0) != 0, (String)"inList expected to be non-null");
        SanityManager.ASSERT((inList.length > 0 ? 1 : 0) != 0, (String)"inList.length expected to be > 0");
        if (left.isNull()) {
            return SQLBoolean.truthValue(left, inList[0], false);
        }
        int start = 0;
        int finish = inList.length;
        int leftPrecedence = left.typePrecedence();
        DataValueDescriptor comparator = null;
        if (orderedList) {
            while (finish - start > 2) {
                int mid = (finish - start) / 2 + start;
                comparator = leftPrecedence < inList[mid].typePrecedence() ? inList[mid] : left;
                retval = comparator.equals(left, inList[mid]);
                if (retval.equals(true)) {
                    return retval;
                }
                BooleanDataValue goLeft = comparator.greaterThan(inList[mid], left);
                if (goLeft.equals(true)) {
                    finish = mid;
                    continue;
                }
                start = mid;
            }
        }
        for (int index = start; !(index >= finish || (retval = (comparator = leftPrecedence < inList[index].typePrecedence() ? inList[index] : left).equals(left, inList[index])).equals(true) || orderedList && (stop = comparator.greaterThan(inList[index], left)).equals(true)); ++index) {
        }
        return retval;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataValueDescriptor)) {
            return false;
        }
        try {
            return this.compare(2, (DataValueDescriptor)other, true, false);
        }
        catch (StandardException se) {
            return false;
        }
    }

    @Override
    public void setValue(InputStream theStream, int valueLength) throws StandardException {
        this.throwLangSetMismatch("java.io.InputStream");
    }

    @Override
    public void checkHostVariable(int declaredLength) throws StandardException {
    }

    protected final StandardException dataTypeConversion(String targetType) {
        return StandardException.newException((String)"22005", (Object[])new Object[]{targetType, this.getTypeName()});
    }

    protected final StandardException outOfRange() {
        return StandardException.newException((String)"22003", (Object[])new Object[]{this.getTypeName()});
    }

    protected final StandardException invalidFormat() {
        return StandardException.newException((String)"22018", (Object[])new Object[]{this.getTypeName()});
    }
}

