/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.provider.IDNUtil;
import org.bouncycastle.util.IPAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HostnameUtil {
    HostnameUtil() {
    }

    static void checkHostname(String string, X509Certificate x509Certificate, boolean bl) throws CertificateException {
        if (null == string) {
            throw new CertificateException("No hostname specified for HTTPS endpoint ID check");
        }
        if (IPAddress.isValid((String)string)) {
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (null != collection) {
                for (List<?> list : collection) {
                    int n = (Integer)list.get(0);
                    if (7 != n) continue;
                    String string2 = (String)list.get(1);
                    if (string.equalsIgnoreCase(string2)) {
                        return;
                    }
                    try {
                        if (!InetAddress.getByName(string).equals(InetAddress.getByName(string2))) continue;
                        return;
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                    catch (SecurityException securityException) {
                    }
                }
            }
            throw new CertificateException("No subject alternative name found matching IP address " + string);
        }
        if (HostnameUtil.isValidDomainName(string)) {
            ASN1Primitive aSN1Primitive;
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (null != collection) {
                boolean bl2 = false;
                for (List<?> list : collection) {
                    int n = (Integer)list.get(0);
                    if (2 != n) continue;
                    bl2 = true;
                    String string3 = (String)list.get(1);
                    if (!HostnameUtil.matchesDNSName(string, string3, bl)) continue;
                    return;
                }
                if (bl2) {
                    throw new CertificateException("No subject alternative name found matching domain name " + string);
                }
            }
            if ((aSN1Primitive = HostnameUtil.findMostSpecificCN(x509Certificate.getSubjectX500Principal())) instanceof ASN1String && HostnameUtil.matchesDNSName(string, ((ASN1String)aSN1Primitive).getString(), bl)) {
                return;
            }
            throw new CertificateException("No name found matching " + string);
        }
        throw new CertificateException("Invalid hostname specified for HTTPS endpoint ID check");
    }

    private static ASN1Primitive findMostSpecificCN(X500Principal x500Principal) {
        if (null != x500Principal) {
            RDN[] rDNArray = X500Name.getInstance((Object)x500Principal.getEncoded()).getRDNs();
            for (int i = rDNArray.length - 1; i >= 0; --i) {
                AttributeTypeAndValue[] attributeTypeAndValueArray = rDNArray[i].getTypesAndValues();
                for (int j = 0; j < attributeTypeAndValueArray.length; ++j) {
                    AttributeTypeAndValue attributeTypeAndValue = attributeTypeAndValueArray[j];
                    if (!BCStyle.CN.equals((ASN1Primitive)attributeTypeAndValue.getType())) continue;
                    return attributeTypeAndValue.getValue().toASN1Primitive();
                }
            }
        }
        return null;
    }

    private static String getLabel(String string, int n) {
        int n2 = string.indexOf(46, n);
        if (n2 < 0) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }

    private static boolean isValidDomainName(String string) {
        try {
            new BCSNIHostName(string);
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    private static boolean labelMatchesPattern(String string, String string2) {
        String string3;
        int n = string2.indexOf(42);
        if (n < 0) {
            return string.equals(string2);
        }
        int n2 = 0;
        int n3 = 0;
        do {
            int n4;
            if ((n4 = string.indexOf(string3 = string2.substring(n3, n), n2)) < 0 || n3 == 0 && n4 > 0) {
                return false;
            }
            n2 = n4 + string3.length();
        } while ((n = string2.indexOf(42, n3 = n + 1)) >= 0);
        string3 = string.substring(n2);
        String string4 = string2.substring(n3);
        return string3.endsWith(string4);
    }

    private static boolean matchesDNSName(String string, String string2, boolean bl) {
        try {
            string = IDNUtil.toUnicode(IDNUtil.toASCII(string, 0), 0);
            string2 = IDNUtil.toUnicode(IDNUtil.toASCII(string2, 0), 0);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        if (!HostnameUtil.validateWildcards(string2)) {
            return false;
        }
        if (!HostnameUtil.isValidDomainName(string2.replace('*', 'z'))) {
            return false;
        }
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toLowerCase(Locale.ENGLISH);
        return bl ? HostnameUtil.matchesWildcardsAllLabels(string, string2) : HostnameUtil.matchesWildcardsFirstLabel(string, string2);
    }

    private static boolean matchesWildcardsAllLabels(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        if (stringTokenizer.countTokens() != stringTokenizer2.countTokens()) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            if (HostnameUtil.labelMatchesPattern(string4, string3 = stringTokenizer2.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesWildcardsFirstLabel(String string, String string2) {
        String string3;
        String string4 = HostnameUtil.getLabel(string, 0);
        if (!HostnameUtil.labelMatchesPattern(string4, string3 = HostnameUtil.getLabel(string2, 0))) {
            return false;
        }
        String string5 = string.substring(string4.length());
        String string6 = string2.substring(string3.length());
        return string5.equals(string6);
    }

    private static boolean validateWildcards(String string) {
        int n = string.lastIndexOf(42);
        if (n >= 0) {
            if (string.equals("*") || string.equals("*.")) {
                return false;
            }
            int n2 = string.indexOf(46, n + 1);
            if (n2 < 0) {
                return false;
            }
        }
        return true;
    }
}

