/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class KeyStoreUtil {
    KeyStoreUtil() {
    }

    static Key getKey(KeyStore keyStore, String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (null == protectionParameter) {
            throw new UnrecoverableKeyException("requested key requires a password");
        }
        if (protectionParameter instanceof KeyStore.PasswordProtection) {
            KeyStore.PasswordProtection passwordProtection = (KeyStore.PasswordProtection)protectionParameter;
            if (null != passwordProtection.getProtectionAlgorithm()) {
                throw new KeyStoreException("unsupported password protection algorithm");
            }
            return keyStore.getKey(string, passwordProtection.getPassword());
        }
        throw new UnsupportedOperationException();
    }
}

