/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ImportX509TrustManager;
import org.bouncycastle.jsse.provider.ProvAlgorithmChecker;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;
import org.bouncycastle.jsse.provider.TransportData;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ImportX509TrustManager_5
extends BCX509ExtendedTrustManager
implements ImportX509TrustManager {
    final boolean isInFipsMode;
    final JcaJceHelper helper;
    final X509TrustManager x509TrustManager;

    ImportX509TrustManager_5(boolean bl, JcaJceHelper jcaJceHelper, X509TrustManager x509TrustManager) {
        this.isInFipsMode = bl;
        this.helper = jcaJceHelper;
        this.x509TrustManager = x509TrustManager;
    }

    @Override
    public X509TrustManager unwrap() {
        return this.x509TrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.x509TrustManager.checkClientTrusted(ImportX509TrustManager_5.copyChain(x509CertificateArray), string);
        this.checkAdditionalTrust(x509CertificateArray, string, null, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.x509TrustManager.checkClientTrusted(ImportX509TrustManager_5.copyChain(x509CertificateArray), string);
        this.checkAdditionalTrust(x509CertificateArray, string, TransportData.from(socket), false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.x509TrustManager.checkClientTrusted(ImportX509TrustManager_5.copyChain(x509CertificateArray), string);
        this.checkAdditionalTrust(x509CertificateArray, string, TransportData.from(sSLEngine), false);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.x509TrustManager.checkServerTrusted(ImportX509TrustManager_5.copyChain(x509CertificateArray), string);
        this.checkAdditionalTrust(x509CertificateArray, string, null, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.x509TrustManager.checkServerTrusted(ImportX509TrustManager_5.copyChain(x509CertificateArray), string);
        this.checkAdditionalTrust(x509CertificateArray, string, TransportData.from(socket), true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.x509TrustManager.checkServerTrusted(ImportX509TrustManager_5.copyChain(x509CertificateArray), string);
        this.checkAdditionalTrust(x509CertificateArray, string, TransportData.from(sSLEngine), true);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.x509TrustManager.getAcceptedIssuers();
    }

    private void checkAdditionalTrust(X509Certificate[] x509CertificateArray, String string, TransportData transportData, boolean bl) throws CertificateException {
        this.checkAlgorithmConstraints(x509CertificateArray, string, transportData, bl);
        ProvX509TrustManager.checkExtendedTrust(x509CertificateArray, transportData, bl);
    }

    private void checkAlgorithmConstraints(X509Certificate[] x509CertificateArray, String string, TransportData transportData, boolean bl) throws CertificateException {
        BCAlgorithmConstraints bCAlgorithmConstraints = TransportData.getAlgorithmConstraints(transportData, false);
        Set<X509Certificate> set = this.getTrustedCerts();
        KeyPurposeId keyPurposeId = ProvX509TrustManager.getRequiredExtendedKeyUsage(bl);
        int n = ProvX509TrustManager.getRequiredKeyUsage(bl, string);
        try {
            ProvAlgorithmChecker.checkChain(this.isInFipsMode, this.helper, bCAlgorithmConstraints, set, x509CertificateArray, keyPurposeId, n);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CertificateException("Certificates do not conform to algorithm constraints", generalSecurityException);
        }
    }

    private Set<X509Certificate> getTrustedCerts() {
        Object[] objectArray = this.getAcceptedIssuers();
        if (TlsUtils.isNullOrEmpty(objectArray)) {
            return Collections.emptySet();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (null == object) continue;
            hashSet.add(object);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static X509Certificate[] checkChain(X509Certificate[] x509CertificateArray) {
        if (TlsUtils.isNullOrEmpty(x509CertificateArray)) {
            throw new IllegalArgumentException("'chain' must be a chain of at least one certificate");
        }
        return x509CertificateArray;
    }

    private static X509Certificate[] copyChain(X509Certificate[] x509CertificateArray) {
        return (X509Certificate[])ImportX509TrustManager_5.checkChain(x509CertificateArray).clone();
    }
}

