/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derby.impl.tools.ij.utilMain;
import org.apache.derby.tools.JDBCDisplayUtil;

public class Main {
    private utilMain utilInstance;

    public static void main(String[] args) throws IOException {
        Main.mainCore(args, new Main(true));
    }

    public static void mainCore(String[] args, Main main) throws IOException {
        String maxDisplayWidth;
        String outFile;
        LocalizedOutput out;
        LocalizedResource langUtil;
        LocalizedInput in;
        block16: {
            in = null;
            InputStream in1 = null;
            langUtil = LocalizedResource.getInstance();
            out = langUtil.getNewOutput(System.out);
            if (util.invalidArgs(args)) {
                util.Usage(out);
                return;
            }
            boolean gotProp = util.getPropertyArg(args);
            langUtil.init();
            out = langUtil.getNewOutput(System.out);
            main.initAppUI();
            String file = util.getFileArg(args);
            String inputResourceName = util.getInputResourceNameArg(args);
            if (inputResourceName != null) {
                in = langUtil.getNewInput(util.getResourceAsStream(inputResourceName));
                if (in == null) {
                    out.println(langUtil.getTextMessage("IJ_IjErroResoNo", inputResourceName));
                    return;
                }
            } else if (file == null) {
                in = langUtil.getNewInput(System.in);
                out.flush();
            } else {
                try {
                    final String inFile1 = file;
                    in1 = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                        @Override
                        public FileInputStream run() throws FileNotFoundException {
                            return new FileInputStream(inFile1);
                        }
                    });
                    if (in1 != null) {
                        in1 = new BufferedInputStream(in1, 2048);
                        in = langUtil.getNewInput(in1);
                    }
                }
                catch (PrivilegedActionException e) {
                    if (Boolean.getBoolean("ij.searchClassPath")) {
                        in = langUtil.getNewInput(util.getResourceAsStream(file));
                    }
                    if (in != null) break block16;
                    out.println(langUtil.getTextMessage("IJ_IjErroFileNo", file));
                    return;
                }
            }
        }
        if ((outFile = util.getSystemProperty("ij.outfile")) != null && outFile.length() > 0) {
            LocalizedOutput oldOut = out;
            FileOutputStream fos = AccessController.doPrivileged(new PrivilegedAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() {
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(outFile);
                    }
                    catch (FileNotFoundException e) {
                        out = null;
                    }
                    return out;
                }
            });
            out = langUtil.getNewOutput(fos);
            if (out == null) {
                oldOut.println(langUtil.getTextMessage("IJ_IjErroUnabTo", outFile));
            }
        }
        if ((maxDisplayWidth = util.getSystemProperty("maximumDisplayWidth")) == null) {
            maxDisplayWidth = util.getSystemProperty("ij.maximumDisplayWidth");
        }
        if (maxDisplayWidth != null && maxDisplayWidth.length() > 0) {
            try {
                int maxWidth = Integer.parseInt(maxDisplayWidth);
                JDBCDisplayUtil.setMaxDisplayWidth(maxWidth);
            }
            catch (NumberFormatException nfe) {
                out.println(langUtil.getTextMessage("IJ_IjErroMaxiVa", maxDisplayWidth));
            }
        }
        Main me = main.getMain(out);
        me.go(in, out);
        in.close();
        out.close();
    }

    public Main getMain(LocalizedOutput out) {
        return new Main(out);
    }

    public utilMain getutilMain(int numConnections, LocalizedOutput out) {
        return new utilMain(numConnections, out);
    }

    public utilMain getutilMain(int numConnections, LocalizedOutput out, boolean loadSystemProperties) {
        return new utilMain(numConnections, out, loadSystemProperties);
    }

    private void go(LocalizedInput in, LocalizedOutput out) {
        LocalizedInput[] inA = new LocalizedInput[]{in};
        this.utilInstance.go(inA, out);
    }

    public Main() {
        this(null);
    }

    public Main(LocalizedOutput out) {
        if (out == null) {
            out = LocalizedResource.getInstance().getNewOutput(System.out);
        }
        this.utilInstance = this.getutilMain(1, out);
        this.utilInstance.initFromEnvironment();
    }

    public Main(boolean trash) {
    }

    private void initAppUI() {
        LocalizedResource.getInstance();
    }
}

