/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportMapping;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.DtlsAddress;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DTLSTM;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.transport.TLSTM;

public class TransportMappings {
    private static final LogAdapter logger = LogFactory.getLogger(TransportMappings.class);
    public static final String TRANSPORT_MAPPINGS = "org.snmp4j.transportMappings";
    private static final String TRANSPORT_MAPPINGS_DEFAULT = "transports.properties";
    private static TransportMappings instance = null;
    private Hashtable<String, Class<? extends TransportMapping<?>>> transportMappings = null;

    protected TransportMappings() {
    }

    public static TransportMappings getInstance() {
        if (instance == null) {
            instance = new TransportMappings();
        }
        return instance;
    }

    public <A extends Address> TransportMapping<A> createTransportMapping(A transportAddress) {
        Class<TransportMapping<?>> c;
        if (this.transportMappings == null) {
            this.registerTransportMappings();
        }
        if ((c = this.transportMappings.get(transportAddress.getClass().getName())) == null) {
            return null;
        }
        Class[] params = new Class[]{transportAddress.getClass()};
        try {
            try {
                Constructor<TransportMapping<?>> constructor = c.getConstructor(params);
                return constructor.newInstance(transportAddress);
            }
            catch (NoSuchMethodException nsme) {
                Constructor<?>[] cs;
                for (Constructor<?> cons : cs = c.getConstructors()) {
                    Class<?>[] params2 = cons.getParameterTypes();
                    if (params2.length != 1 || !params2[0].isAssignableFrom(params[0])) continue;
                    return (TransportMapping)cons.newInstance(transportAddress);
                }
                logger.error("NoSuchMethodException while instantiating " + c.getName(), nsme);
                return null;
            }
        }
        catch (InvocationTargetException ite) {
            if (logger.isDebugEnabled()) {
                ite.printStackTrace();
            }
            logger.error(ite);
            throw new RuntimeException(ite.getTargetException());
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                ex.printStackTrace();
            }
            logger.error(ex);
            return null;
        }
    }

    protected synchronized void registerTransportMappings() {
        if (SNMP4JSettings.isExtensibilityEnabled()) {
            String transports = System.getProperty(TRANSPORT_MAPPINGS, TRANSPORT_MAPPINGS_DEFAULT);
            InputStream is = TransportMappings.class.getResourceAsStream(transports);
            if (is == null) {
                throw new InternalError("Could not read '" + transports + "' from classpath!");
            }
            Properties props = new Properties();
            try {
                props.load(is);
                Hashtable t = new Hashtable(props.size());
                for (String addressClassName : props.stringPropertyNames()) {
                    String className = props.getProperty(addressClassName);
                    try {
                        Class<?> c = Class.forName(className);
                        t.put(addressClassName, c);
                    }
                    catch (ClassNotFoundException cnfe) {
                        logger.error(cnfe);
                    }
                }
                this.transportMappings = t;
            }
            catch (IOException iox) {
                String txt = "Could not read '" + transports + "': " + iox.getMessage();
                logger.error((Serializable)((Object)txt));
                throw new InternalError(txt);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    logger.warn(ex);
                }
            }
        }
        Hashtable<String, Class> t = new Hashtable<String, Class>(2);
        t.put(UdpAddress.class.getName(), DefaultUdpTransportMapping.class);
        t.put(TcpAddress.class.getName(), DefaultTcpTransportMapping.class);
        t.put(TlsAddress.class.getName(), TLSTM.class);
        t.put(DtlsAddress.class.getName(), DTLSTM.class);
        this.transportMappings = t;
    }

    public <A extends Address> void registerTransportMapping(Class<? extends TransportMapping<A>> transportMappingClass, Class<A> addressClass) {
        if (this.transportMappings == null) {
            this.registerTransportMappings();
        }
        this.transportMappings.put(addressClass.getName(), transportMappingClass);
    }

    public <A extends Address> Class<? extends TransportMapping<?>> unregisterTransportMapping(Class<A> addressClass) {
        if (this.transportMappings != null) {
            return this.transportMappings.remove(addressClass.getName());
        }
        return null;
    }
}

