/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.util.Arrays;
import org.snmp4j.DirectUserTarget;
import org.snmp4j.Target;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecretOctetString;
import org.snmp4j.security.SecurityStateReference;

public class UsmSecurityStateReference
implements SecurityStateReference {
    private byte[] securityName;
    private byte[] securityEngineID;
    private AuthenticationProtocol authenticationProtocol;
    private PrivacyProtocol privacyProtocol;
    private byte[] authenticationKey;
    private byte[] privacyKey;
    private int securityLevel;
    private boolean isCachedForResponseProcessing;

    public void setSecurityName(byte[] securityName) {
        this.securityName = securityName;
    }

    public byte[] getSecurityName() {
        return this.securityName;
    }

    public void setSecurityEngineID(byte[] securityEngineID) {
        this.securityEngineID = securityEngineID;
    }

    public byte[] getSecurityEngineID() {
        return this.securityEngineID;
    }

    public void setAuthenticationProtocol(AuthenticationProtocol authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
    }

    public AuthenticationProtocol getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public void setPrivacyProtocol(PrivacyProtocol privacyProtocol) {
        this.privacyProtocol = privacyProtocol;
    }

    public PrivacyProtocol getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public void setAuthenticationKey(byte[] authenticationKey) {
        this.authenticationKey = authenticationKey;
    }

    public byte[] getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setPrivacyKey(byte[] privacyKey) {
        this.privacyKey = privacyKey;
    }

    public byte[] getPrivacyKey() {
        return this.privacyKey;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    @Override
    public void setCachedForResponseProcessing(boolean isCachedForResponseProcessing) {
        this.isCachedForResponseProcessing = isCachedForResponseProcessing;
    }

    @Override
    public boolean isCachedForResponseProcessing() {
        return this.isCachedForResponseProcessing;
    }

    @Override
    public boolean applyTargetSecurityInformation(Target<?> target) {
        if (target instanceof DirectUserTarget) {
            DirectUserTarget userTarget = (DirectUserTarget)target;
            this.setSecurityName(userTarget.getSecurityName().getValue());
            this.setSecurityLevel(userTarget.getSecurityLevel());
            this.setSecurityEngineID(userTarget.getAuthoritativeEngineID());
            this.setAuthenticationProtocol(userTarget.getAuthenticationProtocol());
            this.setPrivacyProtocol(userTarget.getPrivacyProtocol());
            if (userTarget.getAuthenticationKey() != null) {
                this.authenticationKey = userTarget.getAuthenticationKey().getValue();
                if (userTarget.getPrivacyKey() != null) {
                    this.privacyKey = userTarget.getPrivacyKey().getValue();
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "UsmSecurityStateReference{securityName=" + Arrays.toString(this.securityName) + ", securityEngineID=" + Arrays.toString(this.securityEngineID) + ", authenticationProtocol=" + String.valueOf(this.authenticationProtocol) + ", privacyProtocol=" + String.valueOf(this.privacyProtocol) + ", authenticationKey=" + String.valueOf(SecretOctetString.fromByteArray(this.authenticationKey)) + ", privacyKey=" + String.valueOf(SecretOctetString.fromByteArray(this.privacyKey)) + ", securityLevel=" + this.securityLevel + ", isCachedForResponseProcessing=" + this.isCachedForResponseProcessing + "}";
    }
}

