/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import org.snmp4j.SNMP4JSettings;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.smi.OctetString;

public class SecretOctetString
extends OctetString {
    private static final long serialVersionUID = -9186248947167181339L;
    private static final AuthHMAC192SHA256 digester = new AuthHMAC192SHA256();

    public SecretOctetString(OctetString secret) {
        super(secret);
    }

    public SecretOctetString(byte[] rawValue) {
        super(rawValue);
    }

    public SecretOctetString(byte[] rawValue, int offset, int length) {
        super(rawValue, offset, length);
    }

    public SecretOctetString() {
    }

    public static SecretOctetString fromOctetString(OctetString octetString) {
        if (octetString == null) {
            return null;
        }
        return new SecretOctetString(octetString);
    }

    @Override
    public String toString() {
        if (SNMP4JSettings.isSecretLoggingEnabled().booleanValue()) {
            return super.toString();
        }
        return this.getDigest();
    }

    private String getDigest() {
        try {
            byte[] hash = digester.hash(this.getValue());
            return "{secretSHA256=" + new OctetString(hash).toHexString() + "}";
        }
        catch (InternalError ie) {
            return "{secretSHA256=?>";
        }
    }

    @Override
    public String toHexString() {
        if (SNMP4JSettings.isSecretLoggingEnabled().booleanValue()) {
            return super.toHexString();
        }
        return this.getDigest();
    }

    @Override
    public String toHexString(char separator) {
        if (SNMP4JSettings.isSecretLoggingEnabled().booleanValue()) {
            return super.toHexString(separator);
        }
        return this.getDigest();
    }

    @Override
    public String toString(char separator, int radix) {
        if (SNMP4JSettings.isSecretLoggingEnabled().booleanValue()) {
            return super.toString(separator, radix);
        }
        return this.getDigest();
    }

    @Override
    public String toString(int radix) {
        if (SNMP4JSettings.isSecretLoggingEnabled().booleanValue()) {
            return super.toString(radix);
        }
        return this.getDigest();
    }
}

