/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;

public class InputStreamMarkCursor {
    private final InputStream in;
    private int i = 0;
    private final int markSize;
    private int actualReadTotal;
    private byte[] buf;
    private int endPoint = 0;

    public InputStreamMarkCursor(InputStream in, int markSize) {
        this.in = in;
        this.markSize = markSize;
        this.buf = new byte[0];
    }

    public int read() throws IOException {
        if (this.buf.length == 0 || this.i > this.buf.length) {
            if (this.buf.length != 0) {
                this.in.reset();
            }
            this.buf = new byte[this.buf.length + this.markSize];
            this.in.mark(this.buf.length + this.markSize);
            this.actualReadTotal = this.in.read(this.buf, 0, this.buf.length);
        }
        return this.i >= this.actualReadTotal ? -1 : this.buf[this.i++];
    }

    public void endPoint(int delta) {
        this.endPoint = this.i + delta;
    }

    public void rewind() {
        --this.i;
    }

    public void finish() throws IOException {
        this.in.reset();
        this.buf = new byte[this.endPoint];
        this.in.read(this.buf, 0, this.endPoint);
    }

    public void reset() throws IOException {
        this.in.reset();
    }
}

